/*
 * Decompiled with CFR 0.152.
 */
package pi;

import a.ByteArray;
import foundation.icon.ee.io.DataReader;
import i.IInstrumentation;
import i.IObject;
import i.IObjectDeserializer;
import i.IObjectSerializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import p.score.Address;
import p.score.ObjectReader;
import s.java.lang.Boolean;
import s.java.lang.Byte;
import s.java.lang.Double;
import s.java.lang.Float;
import s.java.lang.Integer;
import s.java.lang.Long;
import s.java.lang.Short;
import s.java.lang.String;
import s.java.math.BigInteger;

public class ObjectReaderImpl
extends s.java.lang.Object
implements ObjectReader,
AutoCloseable {
    private DataReader reader;
    private int level = 0;
    private long lastChargePos = 0L;

    public ObjectReaderImpl(DataReader reader) {
        this.reader = reader;
    }

    private void charge() {
        long pos = this.reader.getTotalReadBytes();
        int l = (int)(pos - this.lastChargePos);
        IInstrumentation.charge(2 * l);
        this.lastChargePos = pos;
    }

    private void chargeSkip() {
        long pos = this.reader.getTotalReadBytes();
        int l = (int)(pos - this.lastChargePos);
        IInstrumentation.charge(1 * l);
        this.lastChargePos = pos;
    }

    private <T> T wrapRead(Supplier<T> s) {
        try {
            if (this.reader == null || !this.reader.hasNext()) {
                throw new IllegalStateException();
            }
            T ret = s.get();
            this.charge();
            return ret;
        }
        catch (Exception e) {
            this.reader = null;
            throw e;
        }
    }

    private void wrapVoidRead(Runnable r) {
        try {
            if (this.reader == null || !this.reader.hasNext()) {
                throw new IllegalStateException();
            }
            r.run();
            this.charge();
        }
        catch (Exception e) {
            this.reader = null;
            throw e;
        }
    }

    private <T> T wrapReadOrDefault(Supplier<T> s, T def) {
        try {
            if (this.reader == null) {
                throw new IllegalStateException();
            }
            if (!this.reader.hasNext()) {
                return def;
            }
            T ret = s.get();
            this.charge();
            return ret;
        }
        catch (Exception e) {
            this.reader = null;
            throw e;
        }
    }

    @Override
    public boolean avm_readBoolean() {
        return this.wrapRead(() -> this.reader.readBoolean());
    }

    @Override
    public byte avm_readByte() {
        return this.wrapRead(() -> this.reader.readByte());
    }

    @Override
    public short avm_readShort() {
        return this.wrapRead(() -> this.reader.readShort());
    }

    @Override
    public char avm_readChar() {
        return this.wrapRead(() -> Character.valueOf(this.reader.readChar())).charValue();
    }

    @Override
    public int avm_readInt() {
        return this.wrapRead(() -> this.reader.readInt());
    }

    @Override
    public float avm_readFloat() {
        return this.wrapRead(() -> java.lang.Float.valueOf(this.reader.readFloat())).floatValue();
    }

    @Override
    public long avm_readLong() {
        return this.wrapRead(() -> this.reader.readLong());
    }

    @Override
    public double avm_readDouble() {
        return this.wrapRead(() -> this.reader.readDouble());
    }

    @Override
    public BigInteger avm_readBigInteger() {
        return this.wrapRead(() -> {
            java.math.BigInteger u = this.reader.readBigInteger();
            return BigInteger.newWithCharge(u);
        });
    }

    @Override
    public String avm_readString() {
        return this.wrapRead(() -> {
            java.lang.String u = this.reader.readString();
            return String.newWithCharge(u);
        });
    }

    @Override
    public ByteArray avm_readByteArray() {
        return this.wrapRead(() -> {
            byte[] u = this.reader.readByteArray();
            return ByteArray.newWithCharge(u);
        });
    }

    @Override
    public Address avm_readAddress() {
        return this.wrapRead(() -> {
            byte[] u = this.reader.readByteArray();
            if (u.length != 21) {
                throw new IllegalStateException();
            }
            return Address.newWithCharge(u);
        });
    }

    @Override
    public <T extends IObject> T avm_read(s.java.lang.Class<T> c) {
        return (T)this.wrapRead(() -> this.read(c));
    }

    public <T extends IObject> T read(s.java.lang.Class<T> c) {
        IObject res = this._read(c.getRealClass());
        return (T)res;
    }

    @Override
    public <T extends IObject> T avm_readOrDefault(s.java.lang.Class<T> c, T def) {
        return (T)this.wrapReadOrDefault(() -> this.read(c), def);
    }

    @Override
    public <T extends IObject> T avm_readNullable(s.java.lang.Class<T> c) {
        return (T)this.wrapRead(() -> this.readNullable(c));
    }

    private <T extends IObject> T readNullable(s.java.lang.Class<T> c) {
        if (this.reader.readNullity()) {
            this.charge();
            return null;
        }
        this.charge();
        return this.read(c);
    }

    @Override
    public <T extends IObject> T avm_readNullableOrDefault(s.java.lang.Class<T> c, T def) {
        return (T)this.wrapReadOrDefault(() -> this.readNullable(c), def);
    }

    @Override
    public void avm_beginList() {
        IInstrumentation.charge(100);
        this.wrapVoidRead(() -> {
            ++this.level;
            this.reader.readListHeader();
        });
    }

    @Override
    public void avm_beginMap() {
        IInstrumentation.charge(100);
        this.wrapVoidRead(() -> {
            ++this.level;
            this.reader.readMapHeader();
        });
    }

    @Override
    public boolean avm_beginNullableList() {
        IInstrumentation.charge(100);
        return this.wrapRead(() -> {
            if (this.reader.readNullity()) {
                return false;
            }
            this.charge();
            ++this.level;
            this.reader.readListHeader();
            return true;
        });
    }

    @Override
    public boolean avm_beginNullableMap() {
        IInstrumentation.charge(100);
        return this.wrapRead(() -> {
            if (this.reader.readNullity()) {
                return false;
            }
            this.charge();
            ++this.level;
            this.reader.readMapHeader();
            return true;
        });
    }

    @Override
    public boolean avm_hasNext() {
        IInstrumentation.charge(100);
        try {
            if (this.reader == null) {
                throw new IllegalStateException();
            }
            return this.reader.hasNext();
        }
        catch (Exception e) {
            this.reader = null;
            throw e;
        }
    }

    @Override
    public void avm_end() {
        IInstrumentation.charge(100);
        try {
            if (this.reader == null) {
                throw new IllegalStateException();
            }
            if (this.level == 0) {
                throw new IllegalStateException();
            }
            while (this.reader.hasNext()) {
                this.reader.skip(1);
            }
            this.chargeSkip();
            this.reader.readFooter();
            this.charge();
            --this.level;
        }
        catch (Exception e) {
            this.reader = null;
            throw e;
        }
    }

    public <T extends IObject> IObject _read(Class<T> c) {
        if (c == Boolean.class) {
            return Boolean.avm_valueOf(this.reader.readBoolean());
        }
        if (c == Byte.class) {
            return Byte.avm_valueOf(this.reader.readByte());
        }
        if (c == Short.class) {
            return Short.avm_valueOf(this.reader.readShort());
        }
        if (c == s.java.lang.Character.class) {
            return s.java.lang.Character.avm_valueOf(this.reader.readChar());
        }
        if (c == Integer.class) {
            return Integer.avm_valueOf(this.reader.readInt());
        }
        if (c == Float.class) {
            return Float.avm_valueOf(this.reader.readFloat());
        }
        if (c == Long.class) {
            return Long.avm_valueOf(this.reader.readLong());
        }
        if (c == Double.class) {
            return Double.avm_valueOf(this.reader.readDouble());
        }
        if (c == String.class) {
            java.lang.String u = this.reader.readString();
            return String.newWithCharge(u);
        }
        if (c == BigInteger.class) {
            java.math.BigInteger u = this.reader.readBigInteger();
            return BigInteger.newWithCharge(u);
        }
        if (c == ByteArray.class) {
            byte[] u = this.reader.readByteArray();
            return ByteArray.newWithCharge(u);
        }
        if (c == Address.class) {
            byte[] u = this.reader.readByteArray();
            if (u.length != 21) {
                throw new IllegalStateException();
            }
            return Address.newWithCharge(u);
        }
        IInstrumentation.charge(100);
        try {
            Method m = c.getDeclaredMethod("avm_readObject", ObjectReader.class);
            if ((m.getModifiers() & 8) == 0 || (m.getModifiers() & 1) == 0) {
                throw new IllegalArgumentException();
            }
            Object res = m.invoke(null, this);
            return (IObject)res;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void avm_skip() {
        this.wrapVoidRead(() -> {
            this.reader.skip(1);
            this.chargeSkip();
        });
    }

    @Override
    public void avm_skip(int count) {
        this.wrapVoidRead(() -> {
            this.reader.skip(count);
            this.chargeSkip();
        });
    }

    @Override
    public void close() {
        this.reader = null;
    }

    @Override
    public void deserializeSelf(Class<?> firstRealImplementation, IObjectDeserializer deserializer) {
        super.deserializeSelf(ObjectReaderImpl.class, deserializer);
        this.reader = null;
    }

    @Override
    public void serializeSelf(Class<?> firstRealImplementation, IObjectSerializer serializer) {
        super.serializeSelf(ObjectReaderImpl.class, serializer);
        assert (this.reader == null);
    }
}

