/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.struct;

import foundation.icon.ee.struct.ClassPropertyMemberInfo;
import foundation.icon.ee.struct.PropertyMember;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassPropertyMemberInfoCollector
extends ClassVisitor {
    private final List<PropertyMember> fields = new ArrayList<PropertyMember>();
    private final List<PropertyMember> getters = new ArrayList<PropertyMember>();
    private final List<PropertyMember> setters = new ArrayList<PropertyMember>();
    private boolean hasAConstructor = false;
    private boolean hasZeroArgPublicConstructor = false;
    private boolean hasCreatableModifier = true;
    private Type type;
    private Type superType;

    public ClassPropertyMemberInfoCollector() {
        super(458752);
    }

    public ClassPropertyMemberInfo getClassPropertyInfo() {
        return new ClassPropertyMemberInfo(this.type, this.superType, this.isCreatable(), this.fields, this.getters, this.setters);
    }

    private boolean isCreatable() {
        return (!this.hasAConstructor || this.hasZeroArgPublicConstructor) && this.hasCreatableModifier;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x400) != 0 || (access & 0x200) != 0) {
            this.hasCreatableModifier = false;
        }
        this.type = Type.getType((String)("L" + name + ";"));
        this.superType = Type.getType((String)("L" + superName + ";"));
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if ((access & 1) != 0 && (access & 8) == 0) {
            this.fields.add(new PropertyMember(0, this.type, name, descriptor));
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    private static boolean isSetter(int access, String name, Type type) {
        if ((access & 1) == 0 || (access & 8) != 0) {
            return false;
        }
        if (name.length() < 4 || !name.startsWith("set")) {
            return false;
        }
        if (type.getArgumentTypes().length != 1) {
            return false;
        }
        return type.getReturnType() == Type.VOID_TYPE;
    }

    private static boolean isGetter(int access, String name, Type type) {
        if ((access & 1) == 0 || (access & 8) != 0 || type.getArgumentTypes().length != 0) {
            return false;
        }
        if ((type.getReturnType() == Type.BOOLEAN_TYPE || type.getReturnType() == Type.getType(Boolean.class)) && name.startsWith("is") && name.length() > 2) {
            return true;
        }
        return type.getReturnType() != Type.VOID_TYPE && name.startsWith("get") && name.length() > 3;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        Type memberType;
        if (name.equals("<init>")) {
            this.hasAConstructor = true;
            if (descriptor.equals("()V") && (access & 8) == 0 && (access & 1) != 0) {
                this.hasZeroArgPublicConstructor = true;
            }
        }
        if (ClassPropertyMemberInfoCollector.isSetter(access, name, memberType = Type.getType((String)descriptor))) {
            this.setters.add(new PropertyMember(2, this.type, name, memberType));
        } else if (ClassPropertyMemberInfoCollector.isGetter(access, name, memberType)) {
            this.getters.add(new PropertyMember(1, this.type, name, memberType));
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }
}

