/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.types;

import java.util.Arrays;
import java.util.Objects;
import org.objectweb.asm.commons.Remapper;

public class Method {
    private final int type;
    private final String name;
    private final int flags;
    private final int indexed;
    private final Parameter[] inputs;
    private final int output;
    private final String outputDescriptor;

    private Method(int type, String name, int flags, int indexed, Parameter[] inputs, int output, String outputDescriptor) {
        this.type = type;
        this.name = name;
        this.flags = flags;
        this.indexed = indexed;
        this.inputs = inputs;
        this.output = output;
        this.outputDescriptor = outputDescriptor;
    }

    public Method remap(Remapper remapper) {
        return new Method(this.type, this.name, this.flags, this.indexed, (Parameter[])Arrays.stream(this.inputs).map(in -> in.remap(remapper)).toArray(Parameter[]::new), this.output, remapper.mapDesc(this.outputDescriptor));
    }

    public static Method newFunction(String name, int flags, Parameter[] inputs, int output, String outputDescriptor) {
        return new Method(0, name, flags, inputs != null ? inputs.length : 0, inputs, output, outputDescriptor);
    }

    public static Method newFunction(String name, int flags, int optional, Parameter[] inputs, int output, String outputDescriptor) {
        if (optional > 0) {
            return new Method(0, name, flags, inputs.length - optional, inputs, output, outputDescriptor);
        }
        return Method.newFunction(name, flags, inputs, output, outputDescriptor);
    }

    public static Method newFallback() {
        return new Method(1, "fallback", 4, 0, new Parameter[0], 0, "V");
    }

    public static Method newEvent(String name, int indexed, Parameter[] inputs) {
        return new Method(2, name, 0, indexed, inputs, 0, "V");
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getIndexed() {
        return this.indexed;
    }

    public Parameter[] getInputs() {
        return this.inputs;
    }

    public int getOutput() {
        return this.output;
    }

    public String toString() {
        return "Method{type=" + this.type + ", name='" + this.name + "', flags=" + this.flags + ", indexed=" + this.indexed + ", inputs=" + Arrays.toString(this.inputs) + ", output=" + this.output + (String)(this.outputDescriptor.isEmpty() ? "" : ", outputDescriptor=" + this.outputDescriptor) + "}";
    }

    public String getOutputDescriptor() {
        return this.outputDescriptor;
    }

    public String getDescriptor() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Parameter p : this.inputs) {
            sb.append(p.getDescriptor());
        }
        sb.append(')');
        sb.append(this.getOutputDescriptor());
        return sb.toString();
    }

    public String getDebugName() {
        if (this.outputDescriptor.isEmpty()) {
            return this.name;
        }
        return this.name + this.getDescriptor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return this.type == method.type && this.flags == method.flags && this.indexed == method.indexed && this.output == method.output && this.name.equals(method.name) && Arrays.equals(this.inputs, method.inputs) && this.outputDescriptor.equals(method.outputDescriptor);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.name, this.flags, this.indexed, this.output, this.outputDescriptor);
        result = 31 * result + Arrays.hashCode(this.inputs);
        return result;
    }

    public static class Parameter {
        String name;
        String descriptor;
        TypeDetail typeDetail;
        boolean optional;

        public Parameter(String name, String descriptor, int type) {
            this(name, descriptor, new TypeDetail(type), false);
        }

        public Parameter(String name, String descriptor, int type, boolean optional) {
            this(name, descriptor, new TypeDetail(type), optional);
        }

        public Parameter(String name, String descriptor, int type, Field[] structFields, boolean optional) {
            this(name, descriptor, new TypeDetail(type, structFields), optional);
        }

        public Parameter(String name, String descriptor, TypeDetail typeDetail, boolean optional) {
            this.name = name;
            this.descriptor = descriptor;
            this.typeDetail = typeDetail;
            this.optional = optional;
        }

        public Parameter remap(Remapper remapper) {
            return new Parameter(this.name, remapper.mapDesc(this.descriptor), this.typeDetail, this.optional);
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int getType() {
            return this.typeDetail.getType();
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Field[] getStructFields() {
            return this.typeDetail.getStructFields();
        }

        public TypeDetail getTypeDetail() {
            return this.typeDetail;
        }

        public String toString() {
            return "Parameter{name='" + this.name + "'" + (String)(this.descriptor.isEmpty() ? "" : ", descriptor=" + this.descriptor) + ", type=" + this.typeDetail.type + (String)(this.typeDetail.structFields != null ? ", structFields=" + Arrays.toString(this.typeDetail.structFields) : "") + ", optional=" + this.optional + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.optional == parameter.optional && this.name.equals(parameter.name) && this.descriptor.equals(parameter.descriptor) && this.typeDetail.equals(parameter.typeDetail);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor, this.typeDetail, this.optional);
        }
    }

    public static class Field {
        String name;
        TypeDetail typeDetail;

        public Field(String name, TypeDetail typeDetail) {
            this.name = name;
            this.typeDetail = typeDetail;
        }

        public Field(String name, int type, Field[] structTypes) {
            this.name = name;
            this.typeDetail = new TypeDetail(type, structTypes);
        }

        public String getName() {
            return this.name;
        }

        public TypeDetail getTypeDetail() {
            return this.typeDetail;
        }

        public int getType() {
            return this.typeDetail.getType();
        }

        public Field[] getStructFields() {
            return this.typeDetail.getStructFields();
        }

        public String toString() {
            return "Field{name='" + this.name + "', type=" + this.typeDetail.type + (String)(this.typeDetail.structFields != null ? ", structFields=" + Arrays.toString(this.typeDetail.structFields) : "") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.name.equals(field.name) && this.typeDetail.equals(field.typeDetail);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.typeDetail);
        }
    }

    public static class TypeDetail {
        int type;
        Field[] structFields;

        public TypeDetail(int type) {
            this.type = type;
        }

        public TypeDetail(int type, Field[] structFields) {
            this.type = type;
            this.structFields = structFields;
        }

        public int getType() {
            return this.type;
        }

        public Field[] getStructFields() {
            return this.structFields;
        }

        public String toString() {
            return "TypeDetail{type=" + this.type + (String)(this.structFields != null ? ", structFields=" + Arrays.toString(this.structFields) : "") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeDetail that = (TypeDetail)o;
            return this.type == that.type && Arrays.equals(this.structFields, that.structFields);
        }

        public int hashCode() {
            int result = Objects.hash(this.type);
            result = 31 * result + Arrays.hashCode(this.structFields);
            return result;
        }
    }

    public static class DataType {
        public static final int NONE = 0;
        public static final int INTEGER = 1;
        public static final int STRING = 2;
        public static final int BYTES = 3;
        public static final int BOOL = 4;
        public static final int ADDRESS = 5;
        public static final int LIST = 6;
        public static final int DICT = 7;
        public static final int STRUCT = 8;
        public static final int DIMENSION_SHIFT = 4;
        public static final int ELEMENT_MASK = 15;

        public static int getElement(int type) {
            return type & 0xF;
        }
    }

    public static class Flags {
        public static final int READONLY = 1;
        public static final int EXTERNAL = 2;
        public static final int PAYABLE = 4;
        public static final int ISOLATED = 8;
    }

    public static class MethodType {
        public static final int FUNCTION = 0;
        public static final int FALLBACK = 1;
        public static final int EVENT = 2;
    }
}

