/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import foundation.icon.ee.types.Method;
import java.io.IOException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageUnpacker;

public class MethodUnpacker {
    public static Method[] readFrom(byte[] data) throws IOException {
        return MethodUnpacker.readFrom(data, true);
    }

    public static Method[] readFrom(byte[] data, boolean longForm) throws IOException {
        try {
            return MethodUnpacker.readFromImpl(data, longForm);
        }
        catch (MessagePackException e) {
            throw new IOException(e);
        }
    }

    private static Method[] readFromImpl(byte[] data, boolean longForm) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])data);
        int size = unpacker.unpackArrayHeader();
        Method[] methods = new Method[size];
        for (int i = 0; i < size; ++i) {
            unpacker.unpackArrayHeader();
            int type = unpacker.unpackInt();
            String name = unpacker.unpackString();
            int flags = unpacker.unpackInt();
            int indexed = unpacker.unpackInt();
            int inputSize = unpacker.unpackArrayHeader();
            if (indexed > inputSize) {
                throw new IOException("Invalid indexed: " + indexed);
            }
            Method.Parameter[] params = new Method.Parameter[inputSize];
            if (inputSize > 0) {
                int j;
                for (j = 0; j < indexed; ++j) {
                    params[j] = MethodUnpacker.getParameter(unpacker, false, longForm);
                }
                for (j = indexed; j < inputSize; ++j) {
                    params[j] = MethodUnpacker.getParameter(unpacker, type == 0, longForm);
                }
            }
            int output = unpacker.unpackArrayHeader();
            String outputDescriptor = "V";
            if (output != 0) {
                output = unpacker.unpackInt();
                if (longForm) {
                    outputDescriptor = unpacker.unpackString();
                }
            }
            if (!longForm) {
                outputDescriptor = "";
            }
            if (type == 0) {
                methods[i] = Method.newFunction(name, flags, inputSize - indexed, params, output, outputDescriptor);
                continue;
            }
            if (type == 1) {
                if ("fallback".equals(name)) {
                    methods[i] = Method.newFallback();
                    continue;
                }
                throw new IOException("Invalid fallback: " + name);
            }
            if (type == 2) {
                methods[i] = Method.newEvent(name, indexed, params);
                continue;
            }
            throw new IOException("Unknown method type: " + type);
        }
        return methods;
    }

    private static Method.Parameter getParameter(MessageUnpacker unpacker, boolean optional, boolean longForm) throws IOException {
        unpacker.unpackArrayHeader();
        String paramName = unpacker.unpackString();
        String paramDescriptor = "";
        if (longForm) {
            paramDescriptor = unpacker.unpackString();
        }
        int paramType = unpacker.unpackInt();
        unpacker.unpackValue();
        Method.Field[] sf = null;
        if ((paramType & 0xF) == 8) {
            sf = MethodUnpacker.unpackStructFields(unpacker);
        }
        return new Method.Parameter(paramName, paramDescriptor, paramType, sf, optional);
    }

    private static Method.Field[] unpackStructFields(MessageUnpacker unpacker) throws IOException {
        int n = unpacker.unpackArrayHeader();
        Method.Field[] res = new Method.Field[n];
        for (int i = 0; i < n; ++i) {
            unpacker.unpackArrayHeader();
            String name = unpacker.unpackString();
            int t = unpacker.unpackInt();
            Method.Field[] sf = null;
            if ((t & 0xF) == 8) {
                sf = MethodUnpacker.unpackStructFields(unpacker);
            } else {
                unpacker.unpackNil();
            }
            res[i] = new Method.Field(name, t, sf);
        }
        return res;
    }
}

