/*
 * Decompiled with CFR 0.152.
 */
package i;

import a.ByteArray;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import p.score.Address;
import s.java.lang.Byte;
import s.java.lang.Character;
import s.java.lang.Integer;
import s.java.lang.Long;
import s.java.lang.Short;
import s.java.lang.String;
import s.java.math.BigInteger;

public class RLPCoder {
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    static final int SHORT_BASE = 128;
    static final int SHORT_LEN_LIMIT = 55;
    static final int LONG_BASE = 183;

    public void write(byte[] bs) {
        this.bos.write(bs, 0, bs.length);
    }

    public byte[] toByteArray() {
        return this.bos.toByteArray();
    }

    public void encode(int v) {
        byte[] bs = java.math.BigInteger.valueOf(v).toByteArray();
        this.encode(bs);
    }

    public void encode(Object v) {
        if (v instanceof String) {
            byte[] bs = ((String)v).getUnderlying().getBytes(StandardCharsets.UTF_8);
            this.encode(bs);
        } else if (v instanceof ByteArray) {
            byte[] bs = ((ByteArray)v).getUnderlying();
            this.encode(bs);
        } else if (v instanceof Address) {
            byte[] bs = ((Address)v).toByteArray();
            this.encode(bs);
        } else if (v instanceof BigInteger) {
            byte[] bs = ((BigInteger)v).getUnderlying().toByteArray();
            this.encode(bs);
        } else if (v instanceof Byte) {
            byte vv = ((Byte)v).getUnderlying();
            byte[] bs = java.math.BigInteger.valueOf(vv).toByteArray();
            this.encode(bs);
        } else if (v instanceof Short) {
            short vv = ((Short)v).getUnderlying();
            byte[] bs = java.math.BigInteger.valueOf(vv).toByteArray();
            this.encode(bs);
        } else if (v instanceof Integer) {
            int vv = ((Integer)v).getUnderlying();
            byte[] bs = java.math.BigInteger.valueOf(vv).toByteArray();
            this.encode(bs);
        } else if (v instanceof Long) {
            long vv = ((Long)v).getUnderlying();
            byte[] bs = java.math.BigInteger.valueOf(vv).toByteArray();
            this.encode(bs);
        } else if (v instanceof Character) {
            char vv = ((Character)v).getUnderlying();
            byte[] bs = java.math.BigInteger.valueOf(vv).toByteArray();
            this.encode(bs);
        } else {
            throw new IllegalArgumentException("bad key type :" + v.getClass());
        }
    }

    private void encode(byte[] bs) {
        int l = bs.length;
        if (l == 1 && (bs[0] & 0xFF) < 128) {
            this.bos.write(bs[0]);
        } else if (l <= 55) {
            this.bos.write(128 + l);
            this.bos.write(bs, 0, l);
        } else if (l <= 255) {
            this.bos.write(184);
            this.bos.write(l);
            this.bos.write(bs, 0, l);
        } else if (l <= 65535) {
            this.bos.write(185);
            this.bos.write(l >> 8);
            this.bos.write(l);
            this.bos.write(bs, 0, l);
        } else if (l <= 0xFFFFFF) {
            this.bos.write(186);
            this.bos.write(l >> 16);
            this.bos.write(l >> 8);
            this.bos.write(l);
            this.bos.write(bs, 0, l);
        } else {
            this.bos.write(187);
            this.bos.write(l >> 24);
            this.bos.write(l >> 16);
            this.bos.write(l >> 8);
            this.bos.write(l);
            this.bos.write(bs, 0, l);
        }
    }
}

