/*
 * Decompiled with CFR 0.152.
 */
package i;

import i.OutOfStackException;

public class StackWatcher {
    public static final int POLICY_DEPTH = 1;
    public static final int POLICY_SIZE = 2;
    private static final int RESERVED_AVM_SLOT = 10;
    private static final int RESERVED_JVM_SLOT = 10;
    private boolean checkDepth = false;
    private boolean checkSize = false;
    private int maxStackDepth = 200;
    private int maxStackSize = 100000;
    private int curDepth = 0;
    private int curSize = 0;

    public void setPolicy(int policy) {
        this.checkDepth = (policy & 1) == 1;
        this.checkSize = (policy & 2) == 2;
    }

    public void reset() {
        this.curDepth = 0;
        this.curSize = 0;
    }

    public int getCurStackSize() {
        return this.curSize;
    }

    public int getCurStackDepth() {
        return this.curDepth;
    }

    public void setMaxStackDepth(int limit) {
        this.maxStackDepth = limit;
    }

    public int getMaxStackDepth() {
        return this.maxStackDepth;
    }

    public void setMaxStackSize(int limit) {
        this.maxStackSize = limit;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void enterMethod(int frameSize) throws OutOfStackException {
        if (this.checkDepth && this.curDepth++ > this.maxStackDepth) {
            this.abortCurrentContract();
        }
        if (this.checkSize && (this.curSize += (frameSize += 20)) > this.maxStackSize) {
            this.abortCurrentContract();
        }
    }

    public void exitMethod(int frameSize) throws OutOfStackException {
        if (this.checkDepth && this.curDepth-- < 0) {
            this.abortCurrentContract();
        }
        if (this.checkSize && (this.curSize -= (frameSize += 20)) < 0) {
            this.abortCurrentContract();
        }
    }

    public void enterCatchBlock(int depth, int size) {
        this.curDepth = depth;
        this.curSize = size;
    }

    private void abortCurrentContract() throws OutOfStackException {
        throw new OutOfStackException();
    }
}

