/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public final class ClassToolchain {
    private final ClassReader reader;
    private final ClassWriter writer;
    private final ClassVisitor classVisitor;
    private final int parsingOptions;

    private ClassToolchain(byte[] bytecode, ClassVisitor visitor, ClassWriter writer, int parsingOptions) {
        this.reader = new ClassReader(bytecode);
        this.classVisitor = visitor;
        this.writer = writer;
        this.parsingOptions = parsingOptions;
    }

    public byte[] runAndGetBytecode() {
        this.reader.accept(this.classVisitor, this.parsingOptions);
        return this.writer.toByteArray();
    }

    public static class TraceToolChainClassVisitor
    extends ToolChainClassVisitor {
        private PrintWriter pw;
        private Printer p;

        public TraceToolChainClassVisitor(Printer p, OutputStream os) {
            super(458752);
            this.p = p;
            this.pw = new PrintWriter(os);
        }

        @Override
        public void setDelegate(ClassVisitor delegate) {
            this.cv = new TraceClassVisitor(delegate, this.p, this.pw);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    public static class ToolChainClassVisitor
    extends ClassVisitor {
        protected ToolChainClassVisitor(int api) {
            super(api, null);
        }

        public void setDelegate(ClassVisitor delegate) {
            this.cv = delegate;
        }
    }

    public static final class Builder {
        private final byte[] bytecode;
        private final List<ToolChainClassVisitor> visitorSequence = new ArrayList<ToolChainClassVisitor>();
        private final int parsingOptions;
        private ClassWriter writer;

        public Builder(byte[] bytecode, int parsingOptions) {
            Objects.requireNonNull(bytecode);
            this.bytecode = bytecode;
            this.parsingOptions = parsingOptions;
        }

        public Builder addNextVisitor(ToolChainClassVisitor visitor) {
            Objects.requireNonNull(visitor);
            this.visitorSequence.add(visitor);
            return this;
        }

        public Creator addWriter(ClassWriter writer) {
            Objects.requireNonNull(writer);
            this.writer = writer;
            return new Creator();
        }

        public final class Creator {
            public ClassToolchain build() {
                Object prevVisitor = Builder.this.writer;
                for (int i = Builder.this.visitorSequence.size() - 1; i >= 0; --i) {
                    ToolChainClassVisitor curVisitor = Builder.this.visitorSequence.get(i);
                    curVisitor.setDelegate((ClassVisitor)prevVisitor);
                    prevVisitor = curVisitor;
                }
                return new ClassToolchain(Builder.this.bytecode, Builder.this.visitorSequence.get(0), Builder.this.writer, Builder.this.parsingOptions);
            }
        }
    }
}

