/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import foundation.icon.ee.types.Address;
import foundation.icon.ee.types.DAppRuntimeState;
import foundation.icon.ee.types.ObjectGraph;
import foundation.icon.ee.types.Result;
import foundation.icon.ee.types.Transaction;
import foundation.icon.ee.util.LogMarker;
import i.AvmError;
import i.AvmException;
import i.GenericPredefinedException;
import i.IBlockchainRuntime;
import i.IInstrumentation;
import i.InstrumentationHelpers;
import i.InternedClasses;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.aion.avm.core.AvmConfiguration;
import org.aion.avm.core.BlockchainRuntimeImpl;
import org.aion.avm.core.FrameContextImpl;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.ReentrantDAppStack;
import org.aion.avm.core.persistence.LoadedDApp;
import org.aion.parallel.TransactionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAppExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DAppExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result call(IExternalState externalState, LoadedDApp dapp, ReentrantDAppStack.ReentrantState stateToResume, TransactionTask task, Address senderAddress, Address dappAddress, Transaction tx, AvmConfiguration conf) throws AvmError {
        int flag;
        Result result = null;
        IInstrumentation threadInstrumentation = IInstrumentation.attachedThreadInstrumentation.get();
        InternedClasses initialClassWrappers = dapp.getInternedClasses();
        DAppRuntimeState oldRS = task.getReentrantDAppStack().getRuntimeState(task.getPrevEID());
        if (oldRS == null) {
            oldRS = dapp.loadRuntimeState(externalState);
        } else {
            dapp.loadRuntimeState(oldRS);
        }
        int nextHashCode = oldRS.getGraph().getNextHash();
        int rawGraphDataLength = oldRS.getGraph().getGraphData().length;
        byte[] cid = externalState.getContractID();
        ReentrantDAppStack.ReentrantState thisState = new ReentrantDAppStack.ReentrantState(dapp, cid, externalState.getCodeID());
        ReentrantDAppStack.ReentrantState prevState = task.getReentrantDAppStack().getTop();
        task.getReentrantDAppStack().pushState(thisState);
        BlockchainRuntimeImpl br = new BlockchainRuntimeImpl(externalState, task, senderAddress, dappAddress, tx, dapp.runtimeSetup, dapp);
        FrameContextImpl fc = new FrameContextImpl(externalState);
        InstrumentationHelpers.pushNewStackFrame(dapp.runtimeSetup, dapp.loader, tx.getLimit(), nextHashCode, initialClassWrappers, fc);
        IBlockchainRuntime previousRuntime = dapp.attachBlockchainRuntime(br);
        try {
            Object ret;
            threadInstrumentation.chargeEnergy(externalState.getStepCost().getStorage(rawGraphDataLength));
            try {
                ret = dapp.callMethod(tx.getMethod(), tx.getParams());
            }
            finally {
                externalState.waitForCallbacks();
            }
            DAppRuntimeState newRS = dapp.saveRuntimeState();
            if (externalState.isReadOnly() && !oldRS.isAcceptableChangeInReadOnly(newRS)) {
                throw new GenericPredefinedException(9);
            }
            if (newRS.getGraph().equalGraphData(oldRS.getGraph())) {
                newRS = new DAppRuntimeState(newRS, oldRS.getGraph().getNextHash());
            } else {
                ObjectGraph postOG = newRS.getGraph();
                byte[] postCallGraphData = postOG.getGraphData();
                int effectiveLen = postCallGraphData.length;
                int replaceOGCost = externalState.getStepCost().setStorageReplace(rawGraphDataLength, effectiveLen);
                threadInstrumentation.chargeEnergy(replaceOGCost);
                if (null == stateToResume) {
                    externalState.putObjectGraph(postOG);
                }
            }
            long energyUsed = tx.getLimit() - threadInstrumentation.energyLeft();
            result = new Result(0, energyUsed, ret);
            if (prevState != null) {
                prevState.inherit(thisState);
                prevState.setRuntimeState(task.getEID(), newRS, externalState.getContractID());
            }
        }
        catch (AvmException e) {
            logger.trace("DApp invocation failed: {}", (Object)e.getMessage());
            if (conf.testMode) {
                e.printStackTrace();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bos));
            logger.trace(LogMarker.Trace, bos.toString());
            long stepUsed = tx.getLimit() - threadInstrumentation.energyLeft();
            result = new Result(e.getCode(), stepUsed, (Object)e.getResultMessage());
        }
        finally {
            flag = InstrumentationHelpers.popExistingStackFrame(dapp.runtimeSetup);
            task.getReentrantDAppStack().popState();
            dapp.attachBlockchainRuntime(previousRuntime);
        }
        result = result.updateStatus(result.getStatus() | flag);
        return result;
    }
}

