/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.arraywrapping;

import a.ArrayElement;
import i.RuntimeAssertionError;
import java.util.ArrayList;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ArrayWrappingClassGenerator
implements Opcodes {
    private static boolean DEBUG = false;
    private static String SHADOW_ARRAY = "a/Array";

    public static byte[] arrayWrappingFactory(String request, ClassLoader loader) {
        if (request.startsWith("w._")) {
            return ArrayWrappingClassGenerator.genWrapperInterface(request, loader);
        }
        if (request.startsWith("a.$")) {
            return ArrayWrappingClassGenerator.genWrapperClass(request, loader);
        }
        return null;
    }

    private static byte[] genWrapperInterface(String requestInterface, ClassLoader loader) {
        String IObject1D;
        String slashName;
        if (DEBUG) {
            System.out.println("*********************************");
            System.out.println("requestInterface : " + requestInterface);
        }
        String wrapperInterfaceSlashName = Utilities.fullyQualifiedNameToInternalName(requestInterface);
        String elementInterfaceSlashName = wrapperInterfaceSlashName.substring("w/".length());
        int dim = ArrayNameMapper.getPrefixSize(elementInterfaceSlashName, '_');
        String elementInterfaceDotName = ArrayNameMapper.getElementInterfaceName(requestInterface);
        Class<?> elementClass = null;
        try {
            elementClass = loader.loadClass(elementInterfaceDotName);
        }
        catch (ClassNotFoundException e) {
            throw RuntimeAssertionError.unreachable("No valid component : " + elementInterfaceDotName);
        }
        Class<?>[] superInterfaceClasses = elementClass.getInterfaces();
        ArrayList<String> elementInterfaceWrapperNames = new ArrayList<String>();
        for (Class<?> curI : superInterfaceClasses) {
            String superInterfaceDotName = ArrayNameMapper.buildArrayDescriptor(dim, ArrayWrappingClassGenerator.typeDescriptorForClass(curI));
            String superInterfaceSlashName = Utilities.fullyQualifiedNameToInternalName(superInterfaceDotName);
            String superInterfaceWrapperSlashName = ArrayNameMapper.getInterfaceWrapper(superInterfaceSlashName);
            elementInterfaceWrapperNames.add(superInterfaceWrapperSlashName);
        }
        if (!elementClass.isInterface() && !elementClass.getName().equals("java.lang.Object")) {
            Class<?> elementSuperClass = elementClass.getSuperclass();
            String superClassDotName = ArrayNameMapper.buildArrayDescriptor(dim, ArrayWrappingClassGenerator.typeDescriptorForClass(elementSuperClass));
            String slashName2 = Utilities.fullyQualifiedNameToInternalName(superClassDotName);
            elementInterfaceWrapperNames.add(ArrayNameMapper.getInterfaceWrapper(slashName2));
        }
        if (ArrayNameMapper.isIObjectInterfaceFormat(elementInterfaceSlashName)) {
            slashName = elementInterfaceSlashName.substring(1);
            String fullSlashName = "w/" + slashName;
            elementInterfaceWrapperNames.add(ArrayNameMapper.getInterfaceWrapper(fullSlashName));
        }
        if (ArrayNameMapper.isObjectInterfaceFormat(elementInterfaceSlashName)) {
            slashName = elementInterfaceSlashName.substring(1);
            String fullSlashName = "w/" + slashName;
            String interfaceName = ArrayNameMapper.getInterfaceWrapper(fullSlashName);
            elementInterfaceWrapperNames.add(interfaceName);
        }
        if (wrapperInterfaceSlashName.equals(IObject1D = "w/_Li/IObject")) {
            elementInterfaceWrapperNames.add("i/IObjectArray");
        }
        if (DEBUG) {
            System.out.println("Generating interface : " + wrapperInterfaceSlashName);
            for (String s : elementInterfaceWrapperNames) {
                System.out.println("Interfaces : " + s);
            }
            System.out.println("Wrapper Dimension : " + dim);
            System.out.println("*********************************");
        }
        return ArrayWrappingClassGenerator.generateInterfaceBytecode(wrapperInterfaceSlashName, elementInterfaceWrapperNames.toArray(new String[elementInterfaceWrapperNames.size()]));
    }

    private static byte[] generateInterfaceBytecode(String wrapperInterfaceSlashName, String[] superInterfaces) {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(54, 1537, wrapperInterfaceSlashName, null, "java/lang/Object", superInterfaces);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static byte[] genWrapperClass(String requestClass, ClassLoader loader) {
        if (DEBUG) {
            System.out.println("*********************************");
            System.out.println("requestClass : " + requestClass);
        }
        String wrapperClassSlashName = Utilities.fullyQualifiedNameToInternalName(requestClass);
        String elementClassSlashName = wrapperClassSlashName.substring("a.".length());
        int dim = ArrayNameMapper.getPrefixSize(elementClassSlashName, '$');
        String elementClassDotName = ArrayNameMapper.getClassWrapperElementName(requestClass);
        byte[] bytecode = null;
        if (!ArrayNameMapper.isPrimitiveElement(elementClassDotName)) {
            Class<?> elementClass = null;
            try {
                elementClass = loader.loadClass(elementClassDotName);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeAssertionError.unreachable("No valid component : " + elementClassDotName);
            }
            String interfaceDotName = ArrayNameMapper.buildArrayDescriptor(dim, ArrayWrappingClassGenerator.typeDescriptorForClass(elementClass));
            String interfaceSlashName = Utilities.fullyQualifiedNameToInternalName(interfaceDotName);
            String interfaceWrapperSlashName = ArrayNameMapper.getInterfaceWrapper(interfaceSlashName);
            String superClassSlashName = "a/ObjectArray";
            bytecode = ArrayWrappingClassGenerator.generateClassBytecode(wrapperClassSlashName, superClassSlashName, dim, new String[]{interfaceWrapperSlashName});
            if (DEBUG) {
                System.out.println("Generating class : " + wrapperClassSlashName);
                System.out.println("Superclass class : " + superClassSlashName);
                System.out.println("Backing Interfaces : " + interfaceWrapperSlashName);
                System.out.println("Wrapper Dimension : " + dim);
                System.out.println("*********************************");
            }
        } else {
            bytecode = ArrayWrappingClassGenerator.generateClassBytecode(wrapperClassSlashName, "a/ObjectArray", dim, null);
            if (DEBUG) {
                System.out.println("Generating Prim Class : " + wrapperClassSlashName);
                System.out.println("Wrapper Dimension : " + dim);
                System.out.println("*********************************");
            }
        }
        RuntimeAssertionError.assertTrue(null != bytecode);
        return bytecode;
    }

    private static byte[] generateClassBytecode(String wrapperClassSlashName, String superClassSlashName, int dimensions, String[] superInterfaceSlashNames) {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(54, 33, wrapperClassSlashName, null, superClassSlashName, superInterfaceSlashNames);
        ArrayWrappingClassGenerator.genSingleDimensionFactory(classWriter, wrapperClassSlashName, 1);
        if (dimensions > 1) {
            ArrayWrappingClassGenerator.genMultiDimensionFactory(classWriter, wrapperClassSlashName, dimensions);
        }
        ArrayWrappingClassGenerator.genConstructor(classWriter, superClassSlashName);
        ArrayWrappingClassGenerator.genClone(classWriter, wrapperClassSlashName);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void genSingleDimensionFactory(ClassWriter cw, String wrapper, int d) {
        String facDesc = ArrayNameMapper.getFactoryDescriptor(wrapper, d);
        MethodVisitor mv = cw.visitMethod(9, "initArray", facDesc, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, wrapper);
        mv.visitInsn(89);
        mv.visitVarInsn(21, 0);
        mv.visitMethodInsn(183, wrapper, "<init>", "(I)V", false);
        mv.visitVarInsn(21, 0);
        mv.visitIntInsn(16, ArrayElement.REF.getEnergy());
        mv.visitMethodInsn(184, SHADOW_ARRAY, "chargeEnergyInitArray", "(II)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private static void genMultiDimensionFactory(ClassWriter cw, String wrapper, int dim) {
        for (int d = 2; d <= dim; ++d) {
            String facDesc = ArrayNameMapper.getFactoryDescriptor(wrapper, d);
            MethodVisitor mv = cw.visitMethod(9, "initArray", facDesc, null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, wrapper);
            mv.visitInsn(89);
            mv.visitVarInsn(21, 0);
            mv.visitMethodInsn(183, wrapper, "<init>", "(I)V", false);
            mv.visitVarInsn(21, 0);
            mv.visitIntInsn(16, ArrayElement.REF.getEnergy());
            mv.visitMethodInsn(184, SHADOW_ARRAY, "chargeEnergyInitArray", "(II)V", false);
            mv.visitVarInsn(58, d);
            mv.visitInsn(3);
            mv.visitVarInsn(54, d + 1);
            Label forLoopHead = new Label();
            mv.visitLabel(forLoopHead);
            mv.visitFrame(1, 2, new Object[]{wrapper, Opcodes.INTEGER}, 0, null);
            mv.visitVarInsn(21, d + 1);
            mv.visitVarInsn(21, 0);
            Label forLoopTail = new Label();
            mv.visitJumpInsn(162, forLoopTail);
            mv.visitVarInsn(25, d);
            mv.visitVarInsn(21, d + 1);
            for (int j = 1; j < d; ++j) {
                mv.visitVarInsn(21, j);
            }
            String childWrapper = wrapper.substring("a/$".length());
            RuntimeAssertionError.assertTrue(childWrapper.startsWith("$"));
            char[] childArray = childWrapper.toCharArray();
            int i = 0;
            while (childArray[i] == '$') {
                childArray[i] = 91;
                ++i;
            }
            childWrapper = new String(childArray);
            childWrapper = ArrayNameMapper.getPreciseArrayWrapperDescriptor(childWrapper);
            String childFacDesc = ArrayNameMapper.getFactoryDescriptor(childWrapper, d - 1);
            mv.visitMethodInsn(184, childWrapper, "initArray", childFacDesc, false);
            mv.visitMethodInsn(182, wrapper, "set", "(ILjava/lang/Object;)V", false);
            mv.visitIincInsn(d + 1, 1);
            mv.visitJumpInsn(167, forLoopHead);
            mv.visitLabel(forLoopTail);
            mv.visitFrame(2, 1, null, 0, null);
            mv.visitVarInsn(25, d);
            mv.visitInsn(176);
            mv.visitMaxs(d + 1, d + 2);
            mv.visitEnd();
        }
    }

    private static void genConstructor(ClassWriter cw, String superName) {
        String initName = "<init>";
        MethodVisitor methodVisitor = cw.visitMethod(1, initName, "(I)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitMethodInsn(183, superName, initName, "(I)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(1, initName, "([Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, superName, initName, "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, "a/ObjectArray", "underlying", "[Ljava/lang/Object;");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(1, initName, "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, superName, initName, "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        String deserializationConstructorDescriptor = "(Ljava/lang/Void;I)V";
        methodVisitor = cw.visitMethod(1, initName, deserializationConstructorDescriptor, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitMethodInsn(183, superName, initName, deserializationConstructorDescriptor, false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(4, 4);
        methodVisitor.visitEnd();
    }

    private static void genClone(ClassWriter cw, String wrapper) {
        String cloneMethodName = "avm_clone";
        String cloneMethodDesc = "()Li/IObject;";
        MethodVisitor methodVisitor = cw.visitMethod(1, cloneMethodName, cloneMethodDesc, null, null);
        methodVisitor.visitLdcInsn((Object)600);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, wrapper, "length", "()I", false);
        methodVisitor.visitMethodInsn(184, SHADOW_ARRAY, "chargeEnergyClone", "(II)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, wrapper, "lazyLoad", "()V", false);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, wrapper);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, wrapper, "underlying", "[Ljava/lang/Object;");
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, wrapper, "underlying", "[Ljava/lang/Object;");
        methodVisitor.visitInsn(190);
        methodVisitor.visitMethodInsn(184, "java/util/Arrays", "copyOf", "([Ljava/lang/Object;I)[Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(183, wrapper, "<init>", "([Ljava/lang/Object;)V", false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(4, 1);
        methodVisitor.visitEnd();
    }

    private static String typeDescriptorForClass(Class<?> clazz) {
        return "L" + clazz.getName() + ";";
    }
}

