/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import i.RuntimeAssertionError;
import java.util.HashMap;
import java.util.Map;
import org.aion.avm.core.ClassToolchain;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class ConstantVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private static final String kClinitName = "<clinit>";
    private static final int kClinitAccess = 8;
    private static final String kClinitDescriptor = "()V";
    private static final String postRenameStringDescriptor = "Ls/java/lang/String;";
    private static final String wrapClassMethodName = "wrapAsClass";
    private static final String wrapClassMethodDescriptor = "(Ljava/lang/Class;)Ls/java/lang/Class;";
    private final String constantClassName;
    private final Map<String, String> constantToFieldMap;
    private final Map<String, String> staticFieldNamesToConstantValues;
    private String thisClassName;
    private MethodNode cachedClinit;

    public ConstantVisitor(String constantClassName, Map<String, String> constantToFieldMap) {
        super(458752);
        this.constantClassName = constantClassName;
        this.constantToFieldMap = constantToFieldMap;
        this.staticFieldNamesToConstantValues = new HashMap<String, String>();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.thisClassName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        Object filteredValue = value;
        if (0 != (access & 8) && null != value && postRenameStringDescriptor.equals(descriptor)) {
            this.staticFieldNamesToConstantValues.put(name, (String)value);
            filteredValue = null;
        }
        return super.visitField(access, name, descriptor, signature, filteredValue);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor visitor = null;
        if (kClinitName.equals(name)) {
            this.cachedClinit = new MethodNode(access, name, descriptor, signature, exceptions);
            visitor = this.cachedClinit;
        } else {
            visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        return new MethodVisitor(458752, visitor){

            public void visitLdcInsn(Object value) {
                if (value instanceof Type && ((Type)value).getSort() == 10) {
                    super.visitLdcInsn(value);
                    super.visitMethodInsn(184, "H", ConstantVisitor.wrapClassMethodName, ConstantVisitor.wrapClassMethodDescriptor, false);
                } else if (value instanceof String) {
                    String staticFieldForConstant = ConstantVisitor.this.constantToFieldMap.get(value);
                    RuntimeAssertionError.assertTrue(null != staticFieldForConstant);
                    super.visitFieldInsn(178, ConstantVisitor.this.constantClassName, staticFieldForConstant, ConstantVisitor.postRenameStringDescriptor);
                } else {
                    RuntimeAssertionError.assertTrue(value instanceof Integer || value instanceof Float || value instanceof Long || value instanceof Double);
                    super.visitLdcInsn(value);
                }
            }
        };
    }

    public void visitEnd() {
        if (null != this.cachedClinit || !this.staticFieldNamesToConstantValues.isEmpty()) {
            MethodVisitor clinitVisitor = super.visitMethod(8, kClinitName, kClinitDescriptor, null, null);
            for (Map.Entry<String, String> elt : this.staticFieldNamesToConstantValues.entrySet()) {
                String staticFieldForConstant = this.constantToFieldMap.get(elt.getValue());
                RuntimeAssertionError.assertTrue(null != staticFieldForConstant);
                clinitVisitor.visitFieldInsn(178, this.constantClassName, staticFieldForConstant, postRenameStringDescriptor);
                clinitVisitor.visitFieldInsn(179, this.thisClassName, elt.getKey(), postRenameStringDescriptor);
            }
            this.staticFieldNamesToConstantValues.clear();
            if (null != this.cachedClinit) {
                this.cachedClinit.accept(clinitVisitor);
            } else {
                clinitVisitor.visitInsn(177);
                clinitVisitor.visitMaxs(1, 0);
                clinitVisitor.visitEnd();
            }
        }
        super.visitEnd();
    }
}

