/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import java.util.Map;
import org.aion.avm.core.ClassToolchain;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class InterfaceFieldNameMappingVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private boolean isInterface = false;
    private Map<String, String> interfaceFieldClassNames;

    public InterfaceFieldNameMappingVisitor(Map<String, String> interfaceFieldClassNames) {
        super(458752);
        this.interfaceFieldClassNames = interfaceFieldClassNames;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x200) != 0) {
            this.isInterface = true;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.isInterface && "<clinit>".equals(name)) {
            return null;
        }
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodVisitor(458752, mv){

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                if (InterfaceFieldNameMappingVisitor.this.interfaceFieldClassNames.keySet().contains(owner)) {
                    owner = InterfaceFieldNameMappingVisitor.this.interfaceFieldClassNames.get(owner);
                }
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (this.isInterface) {
            return null;
        }
        return super.visitField(access, name, descriptor, signature, value);
    }
}

