/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import java.util.ArrayList;
import java.util.List;
import org.aion.avm.core.ClassToolchain;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class LoopingExceptionStrippingVisitor
extends ClassToolchain.ToolChainClassVisitor {
    public LoopingExceptionStrippingVisitor() {
        super(458752);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor underlying = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new ExceptionMethodVisitor(underlying);
    }

    private static class TryCatchBlock {
        public final Label start;
        public final Label end;
        public final Label handler;
        public final String type;

        public TryCatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }

    private static class ExceptionMethodVisitor
    extends MethodVisitor {
        private final List<TryCatchBlock> labels = new ArrayList<TryCatchBlock>();

        public ExceptionMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.labels.add(new TryCatchBlock(start, end, handler, type));
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            for (TryCatchBlock block : this.labels) {
                int handlerIndex = block.handler.getOffset();
                if (handlerIndex < block.end.getOffset()) continue;
                super.visitTryCatchBlock(block.start, block.end, block.handler, block.type);
            }
            super.visitMaxs(maxStack, maxLocals);
        }
    }
}

