/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aion.avm.core.ClassToolchain;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class StringConstantCollectorVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private final Set<String> stringConstants = new HashSet<String>();

    public StringConstantCollectorVisitor() {
        super(458752);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodVisitor(458752, visitor){

            public void visitLdcInsn(Object value) {
                if (value instanceof String) {
                    StringConstantCollectorVisitor.this.stringConstants.add((String)value);
                }
                super.visitLdcInsn(value);
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (8 == (access & 8) && value instanceof String) {
            this.stringConstants.add((String)value);
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public List<String> sortedStringConstants() {
        return this.stringConstants.stream().sorted().collect(Collectors.toList());
    }
}

