/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import java.util.Set;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.ClassHierarchyVerifier;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.CommonType;
import org.aion.avm.core.types.HierarchyVerificationResult;

public final class ClassHierarchyBuilder {
    private ClassHierarchyVerifier verifier = new ClassHierarchyVerifier();
    private ClassRenamer classRenamer;
    private Set<ClassInformation> userClassInfos;
    private Set<ClassInformation> nonUserClassInfos;
    private boolean addShadowJcl = false;
    private boolean addArrays = false;
    private boolean addExceptions = false;
    private boolean addUserClasses = false;
    private boolean addNonUserClasses = false;

    public ClassHierarchyBuilder addShadowJcl() {
        this.addShadowJcl = true;
        return this;
    }

    public ClassHierarchyBuilder addHandwrittenArrayWrappers() {
        this.addArrays = true;
        return this;
    }

    public ClassHierarchyBuilder addPostRenameJclExceptions() {
        this.addExceptions = true;
        return this;
    }

    public ClassHierarchyBuilder addPreRenameUserDefinedClasses(ClassRenamer classRenamer, Set<ClassInformation> classInfos) {
        this.addUserClasses = true;
        this.classRenamer = classRenamer;
        this.userClassInfos = classInfos;
        return this;
    }

    public ClassHierarchyBuilder addPostRenameNonUserDefinedClasses(Set<ClassInformation> classInfos) {
        this.addNonUserClasses = true;
        this.nonUserClassInfos = classInfos;
        return this;
    }

    public ClassHierarchy build() {
        ClassHierarchy hierarchy;
        ClassHierarchy classHierarchy = hierarchy = this.addShadowJcl ? this.createHierarchyWithShadowJclClasses() : new ClassHierarchy();
        if (this.addNonUserClasses) {
            this.addNonUserClasses(hierarchy);
        }
        if (this.addUserClasses) {
            this.addUserClasses(hierarchy);
        }
        if (this.addArrays) {
            this.addHandwrittenArrayWrappersToHierarchy(hierarchy);
        }
        if (this.addExceptions) {
            this.addPostRenameJclExceptionTypes(hierarchy);
        }
        HierarchyVerificationResult result = this.verifier.verifyHierarchy(hierarchy);
        if (!result.success) {
            throw new RejectedClassException(result.getError());
        }
        return hierarchy;
    }

    private ClassHierarchy createHierarchyWithShadowJclClasses() {
        return NodeEnvironment.singleton.deepCopyOfClassHierarchy();
    }

    private void addHandwrittenArrayWrappersToHierarchy(ClassHierarchy hierarchy) {
        for (CommonType type : CommonType.values()) {
            if (!type.dotName.startsWith("a.")) continue;
            hierarchy.add(ClassInformation.postRenameInfofrom(type));
        }
        hierarchy.add(ClassInformation.postRenameInfofrom(CommonType.I_OBJECT_ARRAY));
    }

    private void addPostRenameJclExceptionTypes(ClassHierarchy hierarchy) {
        for (CommonType type : CommonType.values()) {
            if (!type.isShadowException) continue;
            hierarchy.addIfAbsent(ClassInformation.postRenameInfofrom(type));
        }
    }

    private void addUserClasses(ClassHierarchy hierarchy) {
        hierarchy.addPreRenameUserDefinedClasses(this.classRenamer, this.userClassInfos);
    }

    private void addNonUserClasses(ClassHierarchy hierarchy) {
        for (ClassInformation classInfo : this.nonUserClassInfos) {
            hierarchy.add(classInfo);
        }
    }
}

