/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.HashSet;
import java.util.Set;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.CommonType;
import org.aion.avm.core.types.HierarchyVerificationResult;
import org.aion.avm.core.types.IHierarchyNode;

public final class ClassHierarchyVerifier {
    public HierarchyVerificationResult verifyHierarchy(ClassHierarchy hierarchy) {
        if (hierarchy == null) {
            throw new NullPointerException("Cannot verify a null hierarchy.");
        }
        HashSet<IHierarchyNode> nodesBeingExplored = new HashSet<IHierarchyNode>();
        HashSet<IHierarchyNode> nodesFullyExplored = new HashSet<IHierarchyNode>();
        HierarchyVerificationResult result = this.verifyNode(hierarchy.getRoot(), nodesBeingExplored, nodesFullyExplored);
        int numUnvisitedNodes = hierarchy.size() - nodesFullyExplored.size();
        if (result.success && numUnvisitedNodes > 0) {
            return HierarchyVerificationResult.foundUnreachableNodes(numUnvisitedNodes);
        }
        return result;
    }

    private HierarchyVerificationResult verifyNode(IHierarchyNode node, Set<IHierarchyNode> nodesBeingExplored, Set<IHierarchyNode> nodesFullyExplored) {
        RuntimeAssertionError.assertTrue(!nodesBeingExplored.contains(node));
        RuntimeAssertionError.assertTrue(!nodesFullyExplored.contains(node));
        nodesBeingExplored.add(node);
        if (node.isGhostNode()) {
            return HierarchyVerificationResult.foundGhostNode(node.getDotName());
        }
        int numberOfNonInterfaceParents = 0;
        for (IHierarchyNode parent : node.getParents()) {
            if (parent.isGhostNode()) {
                return HierarchyVerificationResult.foundGhostNode(parent.getDotName());
            }
            if (parent.getClassInfo().isInterface) continue;
            ++numberOfNonInterfaceParents;
        }
        if (numberOfNonInterfaceParents > 1) {
            return HierarchyVerificationResult.foundMultipleNonInterfaceSuperClasses(node.getDotName());
        }
        for (IHierarchyNode child : node.getChildren()) {
            if (child.getClassInfo().isInterface && !node.getClassInfo().isInterface && !node.getClassInfo().dotName.equals(CommonType.JAVA_LANG_OBJECT.dotName)) {
                return HierarchyVerificationResult.foundInterfaceWithConcreteSuperClass(child.getDotName());
            }
            if (nodesBeingExplored.contains(child)) {
                return HierarchyVerificationResult.foundCycle(child.getDotName());
            }
            if (nodesBeingExplored.contains(child) || nodesFullyExplored.contains(child)) continue;
            HierarchyVerificationResult childResult = this.verifyNode(child, nodesBeingExplored, nodesFullyExplored);
            if (childResult.success) continue;
            return childResult;
        }
        nodesBeingExplored.remove(node);
        nodesFullyExplored.add(node);
        return HierarchyVerificationResult.successful();
    }
}

