/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.Arrays;
import org.aion.avm.core.types.CommonType;

public final class ClassInformation {
    public final String superClassDotName;
    public final String dotName;
    public final boolean isInterface;
    public final boolean isPreRenameClassInfo;
    private final String[] superInterfacesDotNames;

    private ClassInformation(boolean isPreRenameClass, boolean isInterface, String self, String parent, String[] interfaces) {
        if (self == null) {
            throw new NullPointerException("Cannot construct class info with null self.");
        }
        if (!(self.equals(CommonType.JAVA_LANG_OBJECT.dotName) || isPreRenameClass || parent != null || interfaces != null && interfaces.length != 0)) {
            throw new IllegalArgumentException("Cannot construct class info with no super classes defined: " + self);
        }
        RuntimeAssertionError.assertTrue(!self.contains("/"));
        RuntimeAssertionError.assertTrue(parent == null || !parent.contains("/"));
        this.isPreRenameClassInfo = isPreRenameClass;
        this.isInterface = isInterface;
        this.dotName = self;
        this.superClassDotName = parent;
        String[] stringArray = this.superInterfacesDotNames = interfaces == null ? new String[]{} : new String[interfaces.length];
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                RuntimeAssertionError.assertTrue(interfaces[i] != null && !interfaces[i].contains("/"));
                this.superInterfacesDotNames[i] = interfaces[i];
            }
        }
    }

    public static ClassInformation postRenameInfofrom(CommonType specialType) {
        if (specialType == null) {
            throw new NullPointerException("Cannot create class info from a null special type.");
        }
        return new ClassInformation(false, specialType.isInterface, specialType.dotName, specialType.superClassDotName, specialType.superInterfacesDotNames);
    }

    public static ClassInformation preRenameInfofrom(CommonType specialType) {
        if (specialType == null) {
            throw new NullPointerException("Cannot create class info from a null special type.");
        }
        return new ClassInformation(true, specialType.isInterface, specialType.dotName, specialType.superClassDotName, specialType.superInterfacesDotNames);
    }

    public static ClassInformation preRenameInfoFor(boolean isInterface, String self, String parent, String[] interfaces) {
        return new ClassInformation(true, isInterface, self, parent, interfaces);
    }

    public static ClassInformation postRenameInfoFor(boolean isInterface, String dotName, String superClassDotName, String[] superInterfacesDotNames) {
        String superClass = superClassDotName;
        String[] superInterfaces = superInterfacesDotNames;
        if (isInterface) {
            if (superClassDotName != null && superClassDotName.equals(CommonType.JAVA_LANG_OBJECT.dotName)) {
                superClass = null;
                superInterfaces = ClassInformation.addIObjectIfAbsent(superInterfacesDotNames);
            }
            if (superClassDotName == null && (superInterfacesDotNames == null || superInterfacesDotNames.length == 0)) {
                superInterfaces = ClassInformation.addIObjectIfAbsent(superInterfacesDotNames);
            }
        } else if (superClassDotName == null && (superInterfacesDotNames == null || superInterfacesDotNames.length == 0)) {
            superClass = CommonType.SHADOW_OBJECT.dotName;
        }
        return new ClassInformation(false, isInterface, dotName, superClass, superInterfaces);
    }

    public String[] superClasses() {
        if (this.superClassDotName == null) {
            return this.getInterfaces();
        }
        String[] interfaces = Arrays.copyOf(this.superInterfacesDotNames, this.superInterfacesDotNames.length + 1);
        interfaces[this.superInterfacesDotNames.length] = this.superClassDotName;
        return interfaces;
    }

    public String[] getInterfaces() {
        return Arrays.copyOf(this.superInterfacesDotNames, this.superInterfacesDotNames.length);
    }

    public String rawString() {
        return "[" + (this.isInterface ? "interface" : "class") + "], name = '" + this.dotName + "', super class = '" + this.superClassDotName + "', # of interfaces = " + this.superInterfacesDotNames.length;
    }

    private static String[] addIObjectIfAbsent(String[] interfaces) {
        if (interfaces == null) {
            return new String[]{CommonType.I_OBJECT.dotName};
        }
        for (String interfaceName : interfaces) {
            if (!interfaceName.equals(CommonType.I_OBJECT.dotName)) continue;
            return interfaces;
        }
        String[] interfacesWithIObject = Arrays.copyOf(interfaces, interfaces.length + 1);
        interfacesWithIObject[interfaces.length] = CommonType.I_OBJECT.dotName;
        return interfacesWithIObject;
    }

    public String toString() {
        return "ClassInformation { " + this.rawString() + " }";
    }

    public boolean equals(Object other) {
        if (!(other instanceof ClassInformation)) {
            return false;
        }
        ClassInformation otherInfo = (ClassInformation)other;
        boolean sameSuperClasses = this.superClassDotName == null ? otherInfo.superClassDotName == null : this.superClassDotName.equals(otherInfo.superClassDotName);
        return this.isInterface == otherInfo.isInterface && this.dotName.equals(otherInfo.dotName) && sameSuperClasses && Arrays.equals(this.superInterfacesDotNames, otherInfo.superInterfacesDotNames);
    }

    public int hashCode() {
        int hash = 37;
        hash += this.isInterface ? 1 : 0;
        hash += this.dotName.hashCode();
        return (hash += this.superClassDotName == null ? 0 : this.superClassDotName.hashCode()) + Arrays.hashCode(this.superInterfacesDotNames);
    }
}

