/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.HierarchyNode;
import org.aion.avm.core.types.IHierarchyNode;

public class HierarchyGhostNode
implements IHierarchyNode {
    private final String name;
    private Set<IHierarchyNode> children;

    public HierarchyGhostNode(String name) {
        if (name == null) {
            throw new NullPointerException("Cannot construct ghost node with null name.");
        }
        this.name = name;
        this.children = new HashSet<IHierarchyNode>();
    }

    @Override
    public void addChild(IHierarchyNode node) {
        if (node == null) {
            throw new NullPointerException("Cannot add null child to ghost node: " + this.name);
        }
        RuntimeAssertionError.assertTrue(node instanceof HierarchyNode);
        this.children.add(node);
    }

    @Override
    public void addParent(IHierarchyNode node) {
        throw RuntimeAssertionError.unimplemented("[" + this.name + "] A ghost node cannot have parent nodes.");
    }

    @Override
    public void removeParent(IHierarchyNode node) {
        throw RuntimeAssertionError.unimplemented("[" + this.name + "] A ghost node cannot have parent nodes.");
    }

    @Override
    public String getDotName() {
        return this.name;
    }

    @Override
    public ClassInformation getClassInfo() {
        throw RuntimeAssertionError.unimplemented("[" + this.name + "] A ghost node has no class information.");
    }

    @Override
    public boolean isGhostNode() {
        return true;
    }

    @Override
    public Set<IHierarchyNode> getParents() {
        return Collections.emptySet();
    }

    @Override
    public Set<IHierarchyNode> getChildren() {
        return new HashSet<IHierarchyNode>(this.children);
    }

    public String toString() {
        return "HierarchyGhostNode { " + this.name + " }";
    }
}

