/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.util;

import i.RuntimeAssertionError;

public class DescriptorParser {
    public static final char BYTE = 'B';
    public static final char CHAR = 'C';
    public static final char DOUBLE = 'D';
    public static final char FLOAT = 'F';
    public static final char INTEGER = 'I';
    public static final char LONG = 'J';
    public static final char SHORT = 'S';
    public static final char BOOLEAN = 'Z';
    public static final char ARRAY = '[';
    public static final char OBJECT_START = 'L';
    public static final char OBJECT_END = ';';
    public static final char ARGS_START = '(';
    public static final char ARGS_END = ')';
    public static final char VOID = 'V';

    public static <T> T parse(String descriptor, Callbacks<T> callbacks, T userData) {
        int arrayDimensions = 0;
        StringBuilder parsingObject = null;
        block18: for (int index = 0; index < descriptor.length(); ++index) {
            char c = descriptor.charAt(index);
            if (null != parsingObject) {
                switch (c) {
                    case ';': {
                        userData = callbacks.readObject(arrayDimensions, parsingObject.toString(), userData);
                        arrayDimensions = 0;
                        parsingObject = null;
                        break;
                    }
                    default: {
                        parsingObject.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case 'B': {
                    userData = callbacks.readByte(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'C': {
                    userData = callbacks.readChar(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'D': {
                    userData = callbacks.readDouble(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'F': {
                    userData = callbacks.readFloat(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'I': {
                    userData = callbacks.readInteger(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'J': {
                    userData = callbacks.readLong(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'S': {
                    userData = callbacks.readShort(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'Z': {
                    userData = callbacks.readBoolean(arrayDimensions, userData);
                    arrayDimensions = 0;
                    continue block18;
                }
                case 'V': {
                    RuntimeAssertionError.assertTrue(0 == arrayDimensions);
                    userData = callbacks.readVoid(userData);
                    continue block18;
                }
                case 'L': {
                    parsingObject = new StringBuilder();
                    continue block18;
                }
                case '[': {
                    ++arrayDimensions;
                    continue block18;
                }
                case '(': {
                    RuntimeAssertionError.assertTrue(0 == arrayDimensions);
                    userData = callbacks.argumentStart(userData);
                    continue block18;
                }
                case ')': {
                    RuntimeAssertionError.assertTrue(0 == arrayDimensions);
                    userData = callbacks.argumentEnd(userData);
                    continue block18;
                }
                default: {
                    throw RuntimeAssertionError.unreachable("Unexpected descriptor character: " + c);
                }
            }
        }
        RuntimeAssertionError.assertTrue(0 == arrayDimensions);
        RuntimeAssertionError.assertTrue(null == parsingObject);
        return userData;
    }

    public static abstract class TypeOnlyCallbacks<T>
    implements Callbacks<T> {
        @Override
        public T argumentStart(T userData) {
            throw RuntimeAssertionError.unreachable("Type-only parser received method-style callback");
        }

        @Override
        public T argumentEnd(T userData) {
            throw RuntimeAssertionError.unreachable("Type-only parser received method-style callback");
        }

        @Override
        public T readVoid(T userData) {
            throw RuntimeAssertionError.unreachable("Type-only parser received method-style callback");
        }
    }

    public static interface Callbacks<T> {
        public T argumentStart(T var1);

        public T argumentEnd(T var1);

        public T readObject(int var1, String var2, T var3);

        public T readVoid(T var1);

        public T readBoolean(int var1, T var2);

        public T readShort(int var1, T var2);

        public T readLong(int var1, T var2);

        public T readInteger(int var1, T var2);

        public T readFloat(int var1, T var2);

        public T readDouble(int var1, T var2);

        public T readChar(int var1, T var2);

        public T readByte(int var1, T var2);
    }
}

