/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.verification;

import java.util.HashMap;
import java.util.Map;

public class VerifierClassLoader
extends ClassLoader {
    private final Map<String, byte[]> notYetLoaded;
    private final Map<String, Class<?>> loaded;

    public VerifierClassLoader(Map<String, byte[]> classes) {
        super(VerifierClassLoader.class.getClassLoader());
        this.notYetLoaded = new HashMap<String, byte[]>(classes);
        this.loaded = new HashMap();
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        boolean shouldResolve = resolve;
        if (this.loaded.containsKey(name)) {
            result = this.loaded.get(name);
            shouldResolve = false;
        } else if (this.notYetLoaded.containsKey(name)) {
            byte[] bytecode = this.notYetLoaded.remove(name);
            result = this.defineClass(name, bytecode, 0, bytecode.length);
            this.loaded.put(name, result);
        } else {
            result = this.getParent().loadClass(name);
            shouldResolve = false;
        }
        if (null != result && shouldResolve) {
            this.resolveClass(result);
        }
        if (null == result) {
            throw new ClassNotFoundException();
        }
        return result;
    }

    public int getNotYetLoadedCount() {
        return this.notYetLoaded.size();
    }
}

