/*
 * Decompiled with CFR 0.152.
 */
package pi;

import a.ByteArray;
import foundation.icon.ee.io.DataWriter;
import i.GenericPredefinedException;
import i.IInstrumentation;
import i.IObject;
import i.IObjectArray;
import i.IObjectDeserializer;
import i.IObjectSerializer;
import i.RuntimeAssertionError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import p.score.Address;
import p.score.ByteArrayObjectWriter;
import p.score.ObjectWriter;
import s.java.lang.Boolean;
import s.java.lang.Byte;
import s.java.lang.Character;
import s.java.lang.Double;
import s.java.lang.Float;
import s.java.lang.Integer;
import s.java.lang.Long;
import s.java.lang.Short;
import s.java.lang.String;
import s.java.math.BigInteger;

public class ObjectWriterImpl
extends s.java.lang.Object
implements ByteArrayObjectWriter,
AutoCloseable {
    private DataWriter writer;
    private int level = 0;
    private long lastChargePos = 0L;

    public ObjectWriterImpl(DataWriter writer) {
        this.writer = writer;
    }

    private void charge() {
        long pos = this.writer.getTotalWrittenBytes();
        int l = (int)(pos - this.lastChargePos);
        IInstrumentation.charge(2 * l);
        this.lastChargePos = pos;
    }

    private void wrapWrite(Runnable r) {
        try {
            if (this.writer == null) {
                throw new IllegalStateException();
            }
            r.run();
            this.charge();
        }
        catch (Exception e) {
            this.writer = null;
            throw e;
        }
    }

    @Override
    public void avm_write(boolean v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(byte v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(short v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(char v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(int v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(float v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(long v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(double v) {
        this.wrapWrite(() -> this.writer.write(v));
    }

    @Override
    public void avm_write(BigInteger v) {
        this.wrapWrite(() -> {
            Objects.requireNonNull(v);
            this.writer.write(v.getUnderlying());
        });
    }

    @Override
    public void avm_write(String v) {
        this.wrapWrite(() -> {
            Objects.requireNonNull(v);
            this.writer.write(v.getUnderlying());
        });
    }

    @Override
    public void avm_write(ByteArray v) {
        this.wrapWrite(() -> {
            Objects.requireNonNull(v);
            this.writer.write(v.getUnderlying());
        });
    }

    @Override
    public void avm_write(Address v) {
        this.wrapWrite(() -> {
            Objects.requireNonNull(v);
            this.writer.write(v.toByteArray());
        });
    }

    @Override
    public void avm_write(IObject v) {
        this.wrapWrite(() -> {
            Objects.requireNonNull(v);
            this.write(v);
        });
    }

    private void write(IObject v) {
        Class<?> c = v.getClass();
        if (c == Boolean.class) {
            this.writer.write(((Boolean)v).getUnderlying());
        } else if (c == Byte.class) {
            this.writer.write(((Byte)v).getUnderlying());
        } else if (c == Short.class) {
            this.writer.write(((Short)v).getUnderlying());
        } else if (c == Character.class) {
            this.writer.write(((Character)v).getUnderlying());
        } else if (c == Integer.class) {
            this.writer.write(((Integer)v).getUnderlying());
        } else if (c == Float.class) {
            this.writer.write(((Float)v).getUnderlying());
        } else if (c == Long.class) {
            this.writer.write(((Long)v).getUnderlying());
        } else if (c == Double.class) {
            this.writer.write(((Double)v).getUnderlying());
        } else if (c == BigInteger.class) {
            this.writer.write(((BigInteger)v).getUnderlying());
        } else if (c == String.class) {
            this.writer.write(((String)v).getUnderlying());
        } else if (c == ByteArray.class) {
            this.writer.write(((ByteArray)v).getUnderlying());
        } else if (c == Address.class) {
            this.writer.write(((Address)v).toByteArray());
        } else {
            IInstrumentation.charge(100);
            try {
                Method m = c.getDeclaredMethod("avm_writeObject", ObjectWriter.class, c);
                if ((m.getModifiers() & 8) == 0 || (m.getModifiers() & 1) == 0) {
                    throw new IllegalArgumentException();
                }
                m.invoke(null, this, v);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new IllegalArgumentException();
            }
        }
    }

    private void writeNullable(IObject v) {
        if (v == null) {
            this.writer.writeNullity(true);
            this.charge();
        } else {
            this.writer.writeNullity(false);
            this.charge();
            this.write(v);
        }
    }

    @Override
    public void avm_writeNullable(IObject v) {
        this.wrapWrite(() -> this.writeNullable(v));
    }

    @Override
    public void avm_write(IObjectArray v) {
        this.wrapWrite(() -> {
            for (int i = 0; i < v.length(); ++i) {
                this.write((IObject)v.get(i));
            }
        });
    }

    @Override
    public void avm_writeNullable(IObjectArray v) {
        this.wrapWrite(() -> {
            for (int i = 0; i < v.length(); ++i) {
                this.writeNullable((IObject)v.get(i));
            }
        });
    }

    @Override
    public void avm_writeNull() {
        this.wrapWrite(() -> this.writer.writeNullity(true));
    }

    @Override
    public void avm_beginList(int l) {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            ++this.level;
            this.writer.writeListHeader(l);
        });
    }

    @Override
    public void avm_writeListOf(IObjectArray v) {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            this.writer.writeListHeader(v.length());
            this.charge();
            for (int i = 0; i < v.length(); ++i) {
                Objects.requireNonNull(v.get(i));
                this.write((IObject)v.get(i));
            }
            IInstrumentation.charge(100);
            this.writer.writeFooter();
        });
    }

    @Override
    public void avm_writeListOfNullable(IObjectArray v) {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            this.writer.writeListHeader(v.length());
            this.charge();
            for (int i = 0; i < v.length(); ++i) {
                this.writeNullable((IObject)v.get(i));
            }
            IInstrumentation.charge(100);
            this.writer.writeFooter();
        });
    }

    @Override
    public void avm_beginNullableList(int l) {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            ++this.level;
            this.writer.writeNullity(false);
            this.charge();
            this.writer.writeListHeader(l);
        });
    }

    @Override
    public void avm_beginMap(int l) {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            ++this.level;
            this.writer.writeMapHeader(l);
        });
    }

    @Override
    public void avm_beginNullableMap(int l) {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            ++this.level;
            this.writer.writeNullity(false);
            this.charge();
            this.writer.writeMapHeader(l);
        });
    }

    @Override
    public void avm_end() {
        IInstrumentation.charge(100);
        this.wrapWrite(() -> {
            if (this.level == 0) {
                throw new IllegalStateException();
            }
            this.writer.writeFooter();
            --this.level;
        });
    }

    public void flush() {
        this.wrapWrite(() -> this.writer.flush());
    }

    public byte[] toByteArray() {
        this.wrapWrite(() -> this.writer.flush());
        return this.writer.toByteArray();
    }

    @Override
    public ByteArray avm_toByteArray() {
        return ByteArray.newWithCharge(this.toByteArray());
    }

    @Override
    public void close() {
        this.writer = null;
        this.level = 0;
        this.lastChargePos = 0L;
    }

    public ObjectWriterImpl(Void ignore, int readIndex) {
        super(ignore, readIndex);
    }

    @Override
    public void deserializeSelf(Class<?> firstRealImplementation, IObjectDeserializer deserializer) {
        RuntimeAssertionError.unimplemented("cannot deserialize ObjectWriterImpl");
    }

    @Override
    public void serializeSelf(Class<?> firstRealImplementation, IObjectSerializer serializer) {
        throw new GenericPredefinedException(16);
    }
}

