/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.io;

import foundation.icon.ee.io.DataWriter;
import i.RuntimeAssertionError;
import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;

public class MessagePackDataWriter
implements DataWriter {
    private MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();

    @Override
    public void write(boolean v) {
        try {
            this.packer.packBoolean(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(byte v) {
        try {
            this.packer.packByte(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(short v) {
        try {
            this.packer.packShort(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(char v) {
        try {
            this.packer.packInt((int)v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(int v) {
        try {
            this.packer.packInt(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(float v) {
        try {
            this.packer.packFloat(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(long v) {
        try {
            this.packer.packLong(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(double v) {
        try {
            this.packer.packDouble(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(BigInteger v) {
        try {
            this.packer.packBigInteger(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(String v) {
        try {
            this.packer.packString(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void write(byte[] v) {
        try {
            this.packer.packBinaryHeader(v.length);
            this.packer.writePayload(v);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void writeNullity(boolean nullity) {
        if (nullity) {
            this.writeNull();
        }
    }

    @Override
    public void writeListHeader(int l) {
        try {
            this.packer.packArrayHeader(l);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void writeMapHeader(int l) {
        try {
            this.packer.packMapHeader(l);
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void writeFooter() {
    }

    private void writeNull() {
        try {
            this.packer.packNil();
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.packer.flush();
        }
        catch (IOException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public byte[] toByteArray() {
        this.flush();
        return this.packer.toByteArray();
    }

    @Override
    public long getTotalWrittenBytes() {
        return this.packer.getTotalWrittenBytes();
    }
}

