/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.score;

import foundation.icon.ee.types.Method;
import foundation.icon.ee.util.Unshadower;
import i.RuntimeAssertionError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.objectweb.asm.Type;

public class ScoreClass {
    private static final String METHOD_PREFIX = "avm_";
    private final Class<?> cls;

    public ScoreClass(Class<?> cls) {
        this.cls = cls;
    }

    private static boolean hasSameParameterTypes(Method em, Executable e) {
        Method.Parameter[] in;
        Class<?>[] paramClasses = e.getParameterTypes();
        if (paramClasses.length != (in = em.getInputs()).length) {
            return false;
        }
        for (int i = 0; i < in.length; ++i) {
            Type t = Type.getType(paramClasses[i]);
            String d = Unshadower.unshadowDescriptor(t.getDescriptor());
            if (d.equals(in[i].getDescriptor())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSameReturnType(Method em, java.lang.reflect.Method m) {
        Type t = Type.getType(m.getReturnType());
        String d = Unshadower.unshadowDescriptor(t.getDescriptor());
        return d.equals(em.getOutputDescriptor());
    }

    public Constructor<?> findConstructor(Method em) {
        try {
            Constructor<?>[] ctors;
            for (Constructor<?> c : ctors = this.cls.getConstructors()) {
                if (!ScoreClass.hasSameParameterTypes(em, c)) continue;
                return c;
            }
        }
        catch (SecurityException e) {
            RuntimeAssertionError.unexpected(e);
        }
        return null;
    }

    public java.lang.reflect.Method findMethod(Method em) {
        try {
            for (Class<?> cur = this.cls; cur != null; cur = cur.getSuperclass()) {
                java.lang.reflect.Method[] methods;
                for (java.lang.reflect.Method m : methods = cur.getDeclaredMethods()) {
                    if (!m.getName().equals(METHOD_PREFIX + em.getName()) || !ScoreClass.hasSameParameterTypes(em, m) || !ScoreClass.hasSameReturnType(em, m)) continue;
                    return m;
                }
            }
        }
        catch (SecurityException e) {
            RuntimeAssertionError.unexpected(e);
        }
        return null;
    }
}

