/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.struct;

import foundation.icon.ee.score.EEPType;
import foundation.icon.ee.struct.ClassPropertyMemberInfo;
import foundation.icon.ee.struct.PropertyMember;
import foundation.icon.ee.types.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

public class StructDB {
    private final Map<Type, ClassPropertyMemberInfo> cpiMap;
    private final Map<Type, List<PropertyMember>> rPropsMap = new HashMap<Type, List<PropertyMember>>();
    private final Map<Type, List<PropertyMember>> wPropsMap = new HashMap<Type, List<PropertyMember>>();
    private final Set<Type> parameterStructs = new HashSet<Type>();
    private final Set<Type> returnStructs = new HashSet<Type>();

    public StructDB(Map<String, byte[]> classMap) {
        this(classMap, false);
    }

    public StructDB(Map<String, byte[]> classMap, boolean onlyPublicClass) {
        this.cpiMap = ClassPropertyMemberInfo.map(classMap, onlyPublicClass);
        this.updatePropsMap();
    }

    private void requireNoCyclicInheritance(ClassPropertyMemberInfo cpi) {
        ArrayList<Type> visited = new ArrayList<Type>();
        while (cpi != null) {
            if (visited.contains(cpi.getType())) {
                throw new IllegalArgumentException("cyclic inheritance " + cpi.getType().getClassName());
            }
            visited.add(cpi.getType());
            cpi = this.cpiMap.get(cpi.getSuperType());
        }
    }

    private void uniteByName(List<PropertyMember> list, List<PropertyMember> r) {
        block0: for (PropertyMember sp : r) {
            for (PropertyMember wp : list) {
                if (!sp.getName().equals(wp.getName())) continue;
                continue block0;
            }
            list.add(sp);
        }
    }

    private List<PropertyMember> getRProps(ClassPropertyMemberInfo cpi) {
        ArrayList<PropertyMember> rProps = new ArrayList<PropertyMember>();
        ClassPropertyMemberInfo cur = cpi;
        while (cur != null) {
            this.uniteByName(rProps, cur.getGetters());
            cur = this.cpiMap.get(cur.getSuperType());
        }
        cur = cpi;
        while (cur != null) {
            this.uniteByName(rProps, cur.getFields());
            cur = this.cpiMap.get(cur.getSuperType());
        }
        if (rProps.isEmpty()) {
            return null;
        }
        return rProps;
    }

    private List<PropertyMember> getWProps(ClassPropertyMemberInfo cpi) {
        if (!cpi.isCreatable()) {
            return null;
        }
        ArrayList<PropertyMember> wProps = new ArrayList<PropertyMember>();
        ClassPropertyMemberInfo cur = cpi;
        while (cur != null) {
            block1: for (PropertyMember sp : cur.getSetters()) {
                for (PropertyMember wp : wProps) {
                    if (!sp.getName().equals(wp.getName())) continue;
                    if (sp.getType().equals((Object)wp.getType())) continue block1;
                    return null;
                }
                wProps.add(sp);
            }
            cur = this.cpiMap.get(cur.getSuperType());
        }
        cur = cpi;
        while (cur != null) {
            this.uniteByName(wProps, cur.getFields());
            cur = this.cpiMap.get(cur.getSuperType());
        }
        if (wProps.isEmpty()) {
            return null;
        }
        return wProps;
    }

    private boolean isValidStruct(Type t, Map<Type, List<PropertyMember>> propsMap) {
        try {
            new TypeDetailCreator(propsMap).getTypeDetail(t);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void updatePropsMap() {
        HashMap<Type, List<PropertyMember>> lwPropsMap = new HashMap<Type, List<PropertyMember>>();
        HashMap<Type, List<PropertyMember>> lrPropsMap = new HashMap<Type, List<PropertyMember>>();
        for (Map.Entry<Type, ClassPropertyMemberInfo> entry : this.cpiMap.entrySet()) {
            List<PropertyMember> props;
            ClassPropertyMemberInfo c = entry.getValue();
            this.requireNoCyclicInheritance(c);
            if (c.isCreatable() && (props = this.getWProps(c)) != null) {
                lwPropsMap.put(c.getType(), props);
            }
            if ((props = this.getRProps(c)) == null) continue;
            lrPropsMap.put(c.getType(), props);
        }
        for (Map.Entry<Object, ClassPropertyMemberInfo> entry : lwPropsMap.entrySet()) {
            if (!this.isValidStruct((Type)entry.getKey(), lwPropsMap)) continue;
            this.wPropsMap.put((Type)entry.getKey(), (List)((Object)entry.getValue()));
        }
        for (Map.Entry<Object, ClassPropertyMemberInfo> entry : lrPropsMap.entrySet()) {
            if (!this.isValidStruct((Type)entry.getKey(), lrPropsMap)) continue;
            this.rPropsMap.put((Type)entry.getKey(), (List)((Object)entry.getValue()));
        }
    }

    public boolean isWritableStruct(Type t) {
        return this.wPropsMap.containsKey(t);
    }

    public boolean isReadableStruct(Type t) {
        return this.rPropsMap.containsKey(t);
    }

    public List<PropertyMember> getReadableProperties(Type type) {
        return this.rPropsMap.get(type);
    }

    public List<PropertyMember> getWritableProperties(Type type) {
        return this.wPropsMap.get(type);
    }

    public boolean isValidParamTypeElement(Type type) {
        return EEPType.fromBasicParamType.containsKey(type) || this.isWritableStruct(type);
    }

    public boolean isValidParamType(Type type) {
        if (type.getSort() == 9) {
            return this.isValidParamTypeElement(type.getElementType());
        }
        return this.isValidParamTypeElement(type);
    }

    public boolean isValidReturnTypeElement(Type type) {
        return EEPType.fromBasicReturnType.containsKey(type) || this.isReadableStruct(type);
    }

    public boolean isValidReturnType(Type type) {
        if (type.getSort() == 9) {
            return this.isValidReturnTypeElement(type.getElementType());
        }
        return this.isValidReturnTypeElement(type);
    }

    public Method.TypeDetail getDetailFromParameterType(Type t) {
        Integer eepType = EEPType.fromBasicParamType.get(t);
        if (eepType != null) {
            return new Method.TypeDetail(eepType);
        }
        return new TypeDetailCreator(this.wPropsMap).getTypeDetail(t);
    }

    public void addParameterType(Type t) {
        ReferredStructCollector rtc = new ReferredStructCollector(this.wPropsMap);
        this.parameterStructs.addAll(rtc.getReferredStructs(t));
    }

    public Set<Type> getParameterStructs() {
        return this.parameterStructs;
    }

    public int getEEPTypeFromReturnType(Type t) {
        Integer eepType = EEPType.fromBasicReturnType.get(t);
        if (eepType != null) {
            return eepType;
        }
        if (t.getSort() == 9 && this.isValidReturnTypeElement(t.getElementType())) {
            return 6;
        }
        if (this.isReadableStruct(t)) {
            return 7;
        }
        throw new IllegalArgumentException();
    }

    public void addReturnType(Type t) {
        ReferredStructCollector rtc = new ReferredStructCollector(this.rPropsMap);
        this.returnStructs.addAll(rtc.getReferredStructs(t));
    }

    public Set<Type> getReturnStructs() {
        return this.returnStructs;
    }

    private static class ReferredStructCollector {
        private final Map<Type, List<PropertyMember>> propsMap;

        public ReferredStructCollector(Map<Type, List<PropertyMember>> propsMap) {
            this.propsMap = propsMap;
        }

        void visit(Set<Type> rs, Type t) {
            List<PropertyMember> props;
            if (t.getSort() == 9) {
                this.visit(rs, t.getElementType());
            }
            if ((props = this.propsMap.get(t)) == null) {
                return;
            }
            rs.add(t);
            for (PropertyMember p : props) {
                this.visit(rs, p.getType());
            }
        }

        Set<Type> getReferredStructs(Type t) {
            HashSet<Type> rs = new HashSet<Type>();
            this.visit(rs, t);
            return rs;
        }
    }

    private static class TypeDetailCreator {
        private final Map<Type, List<PropertyMember>> propsMap;
        private final List<Type> visiting = new ArrayList<Type>();

        public TypeDetailCreator(Map<Type, List<PropertyMember>> propsMap) {
            this.propsMap = propsMap;
        }

        Method.TypeDetail getTypeDetail(Type t) {
            if (t.getSort() == 9) {
                int elemEEPType;
                Method.TypeDetail elemTD;
                Type elemType = t.getElementType();
                if (elemType.getSort() == 3) {
                    elemTD = new Method.TypeDetail(3);
                    elemEEPType = t.getDimensions() - 1 << 4 | elemTD.getType();
                } else {
                    elemTD = this.getTypeDetail(elemType);
                    elemEEPType = t.getDimensions() << 4 | elemTD.getType();
                }
                return new Method.TypeDetail(elemEEPType, elemTD.getStructFields());
            }
            Integer eepType = EEPType.fromBasicFieldType.get(t);
            if (eepType != null) {
                return new Method.TypeDetail(eepType);
            }
            List<PropertyMember> props = this.propsMap.get(t);
            if (props == null) {
                throw new IllegalArgumentException("invalid t " + t.getClassName());
            }
            if (this.visiting.contains(t)) {
                throw new IllegalArgumentException("cyclic property in " + t.getClassName());
            }
            this.visiting.add(t);
            ArrayList<Method.Field> fields = new ArrayList<Method.Field>();
            for (PropertyMember p : props) {
                Method.TypeDetail ftd = this.getTypeDetail(p.getType());
                fields.add(new Method.Field(p.getName(), ftd.getType(), ftd.getStructFields()));
            }
            this.visiting.remove(this.visiting.size() - 1);
            return new Method.TypeDetail(8, fields.toArray(new Method.Field[0]));
        }
    }
}

