/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.types;

import foundation.icon.ee.types.Bytes;
import java.util.Arrays;

public class Address {
    public static final int LENGTH = 21;
    private final byte prefix;
    private final byte[] body;

    public Address(byte[] input) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input.length != 21) {
            throw new IllegalArgumentException("Illegal format");
        }
        this.prefix = input[0];
        this.body = Arrays.copyOfRange(input, 1, input.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Address) {
            Address other = (Address)obj;
            return this.prefix == other.prefix && Arrays.equals(this.body, other.body);
        }
        return false;
    }

    public String toString() {
        return (this.prefix == 0 ? "hx" : "cx") + Bytes.toHexString(this.body);
    }

    public byte[] toByteArray() {
        byte[] ba = new byte[21];
        ba[0] = this.prefix;
        System.arraycopy(this.body, 0, ba, 1, this.body.length);
        return ba;
    }
}

