/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.types;

import foundation.icon.ee.types.Bytes;
import foundation.icon.ee.util.Crypto;
import java.util.Arrays;

public class ObjectGraph {
    private final int nextHash;
    private final byte[] graphHash;
    private final byte[] graphData;

    public ObjectGraph(int nextHash, byte[] graphHash, byte[] graphData) {
        this.nextHash = nextHash;
        this.graphHash = graphHash;
        this.graphData = graphData;
    }

    public ObjectGraph(ObjectGraph base, int newNextHash) {
        this(newNextHash, base.graphHash, base.getGraphData());
    }

    public ObjectGraph(int nextHash, byte[] graphData) {
        this(nextHash, Crypto.sha3_256(graphData), graphData);
    }

    public int getNextHash() {
        return this.nextHash;
    }

    public byte[] getGraphHash() {
        return this.graphHash;
    }

    public byte[] getGraphData() {
        return this.graphData;
    }

    public boolean equalGraphData(ObjectGraph objGraph) {
        if (this.graphHash != null && objGraph.graphHash != null) {
            return Arrays.equals(this.graphHash, objGraph.graphHash);
        }
        return Arrays.equals(this.graphData, objGraph.graphData);
    }

    public String toString() {
        return "ObjectGraph{nextHash=" + this.nextHash + ", graphHash=" + Bytes.toHexString(this.graphHash) + ", graphData=" + (this.graphData == null ? null : Integer.valueOf(this.graphData.length)) + "}";
    }
}

