/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.types;

import foundation.icon.ee.types.Address;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public final class Transaction {
    private final Address from;
    private final Address to;
    private final byte[] txHash;
    private final int txIndex;
    private final long txTimestamp;
    private final BigInteger value;
    private final BigInteger nonce;
    private final long limit;
    private final boolean isCreate;
    private final String method;
    private final Object[] params;

    public Transaction(Address from, Address to, BigInteger value, BigInteger nonce, long limit, String method, Object[] params, byte[] txHash, int txIndex, long txTimestamp, boolean isCreate) {
        if (to == null) {
            throw new NullPointerException("No destination");
        }
        if (null == from && txHash != null) {
            throw new NullPointerException("No sender");
        }
        if (null == value) {
            throw new NullPointerException("No value");
        }
        if (null == nonce) {
            throw new NullPointerException("No nonce");
        }
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative value");
        }
        if (nonce.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative nonce");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Negative step limit");
        }
        if (null == method && !isCreate) {
            throw new NullPointerException("Null method for call transaction");
        }
        if (null == params) {
            throw new NullPointerException("Null params");
        }
        this.from = from;
        this.to = to;
        if (txHash != null) {
            this.txHash = new byte[txHash.length];
            System.arraycopy(txHash, 0, this.txHash, 0, txHash.length);
        } else {
            this.txHash = null;
        }
        this.txIndex = txIndex;
        this.txTimestamp = txTimestamp;
        this.value = value;
        this.nonce = nonce;
        this.limit = limit;
        this.isCreate = isCreate;
        this.method = method;
        this.params = params;
    }

    public Address getSender() {
        return this.from;
    }

    public Address getDestination() {
        return this.to;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public long getTxTimestamp() {
        return this.txTimestamp;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public long getLimit() {
        return this.limit;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isCreate() {
        return this.isCreate;
    }

    public byte[] copyOfTransactionHash() {
        if (this.txHash == null) {
            return null;
        }
        byte[] copy = new byte[this.txHash.length];
        System.arraycopy(this.txHash, 0, copy, 0, this.txHash.length);
        return copy;
    }

    public Object[] getParams() {
        Object[] paramsCopy = new Object[this.params.length];
        System.arraycopy(this.params, 0, paramsCopy, 0, this.params.length);
        return paramsCopy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction other = (Transaction)o;
        return this.txIndex == other.txIndex && this.txTimestamp == other.txTimestamp && this.isCreate == other.isCreate && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Arrays.equals(this.txHash, other.txHash) && Objects.equals(this.value, other.value) && Objects.equals(this.nonce, other.nonce) && Objects.equals(this.limit, other.limit) && Objects.equals(this.method, other.method) && Arrays.equals(this.params, other.params);
    }

    public int hashCode() {
        int result = Objects.hash(this.from, this.to, this.txIndex, this.txTimestamp, this.value, this.nonce, this.limit, this.isCreate, this.method);
        result = 31 * result + Arrays.hashCode(this.txHash);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public String toString() {
        return "Transaction{from=" + this.from + ", to=" + this.to + ", txHash=" + Arrays.toString(this.txHash) + ", txIndex=" + this.txIndex + ", txTimestamp=" + this.txTimestamp + ", value=" + this.value + ", nonce=" + this.nonce + ", limit=" + this.limit + ", isCreate=" + this.isCreate + ", method='" + this.method + "', params=" + Arrays.toString(this.params) + "}";
    }
}

