/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import foundation.icon.ee.util.Disposable;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DisposableReferenceQueue<T>
extends ReferenceQueue<T> {
    private static final int DEFAULT_CONSUME_INTERVAL = 300;

    public DisposableReferenceQueue() {
        this(null, 0);
    }

    private DisposableReferenceQueue(ScheduledExecutorService ses, int intervalMilli) {
        if (ses == null) {
            ses = Lazy.ses;
        }
        if (intervalMilli <= 0) {
            intervalMilli = 300;
        }
        ses.scheduleAtFixedRate(this::consumeAll, intervalMilli, intervalMilli, TimeUnit.MILLISECONDS);
    }

    public void consumeAll() {
        Disposable d;
        while ((d = (Disposable)((Object)this.poll())) != null) {
            d.dispose();
        }
    }

    private static class Lazy {
        private static final ScheduledExecutorService ses = Lazy.newSES();

        private Lazy() {
        }

        private static ScheduledExecutorService newSES() {
            ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(1);
            stpe.allowCoreThreadTimeOut(true);
            return stpe;
        }
    }
}

