/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import foundation.icon.ee.types.Method;
import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.core.MessageBufferPacker;

public class MethodPacker {
    public static void writeTo(Method m, MessageBufferPacker packer, boolean longForm) throws IOException {
        packer.packArrayHeader(6);
        packer.packInt(m.getType());
        packer.packString(m.getName());
        packer.packInt(m.getFlags());
        packer.packInt(m.getIndexed());
        if (m.getInputs() != null) {
            packer.packArrayHeader(m.getInputs().length);
            for (Method.Parameter p : m.getInputs()) {
                int additionalFields;
                boolean isStruct = Method.DataType.getElement(p.getType()) == 8;
                int n = additionalFields = isStruct ? 1 : 0;
                if (longForm) {
                    packer.packArrayHeader(4 + additionalFields);
                    packer.packString(p.getName());
                    packer.packString(p.getDescriptor());
                } else {
                    packer.packArrayHeader(3 + additionalFields);
                    packer.packString(p.getName());
                }
                packer.packInt(p.getType());
                if (p.isOptional()) {
                    MethodPacker.packDefaultValue(packer, p.getType());
                } else {
                    packer.packNil();
                }
                if (!isStruct) continue;
                MethodPacker.packStructFields(packer, p.getStructFields());
            }
        } else {
            packer.packArrayHeader(0);
        }
        if (m.getOutput() != 0) {
            packer.packArrayHeader(1);
            packer.packInt(m.getOutput());
            if (longForm) {
                packer.packString(m.getOutputDescriptor());
            }
        } else {
            packer.packArrayHeader(0);
        }
    }

    private static void packDefaultValue(MessageBufferPacker packer, int type) throws IOException {
        if (type == 1 || type == 4) {
            byte[] ba = BigInteger.valueOf(0L).toByteArray();
            packer.packBinaryHeader(ba.length);
            packer.writePayload(ba);
        } else {
            packer.packNil();
        }
    }

    private static void packStructFields(MessageBufferPacker packer, Method.Field[] fields) throws IOException {
        packer.packArrayHeader(fields.length);
        for (Method.Field f : fields) {
            packer.packArrayHeader(3);
            packer.packString(f.getName());
            int t = f.getType();
            packer.packInt(t);
            if (Method.DataType.getElement(t) == 8) {
                MethodPacker.packStructFields(packer, f.getStructFields());
                continue;
            }
            packer.packNil();
        }
    }
}

