/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import foundation.icon.ee.types.Method;
import java.io.IOException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageUnpacker;

public class MethodUnpacker {
    private static final int MAX_METHODS = 256;
    private static final int MAX_INPUTS = 64;
    private static final int MAX_FIELDS = 64;
    private static final int MAX_STRUCT_DEPTH = 4;

    private static int ensureMaxSize(int max, int size) throws IOException {
        if (size < 0 || max <= size) {
            throw new IOException("Invalid size");
        }
        return size;
    }

    private static void ensureSize(int exp, int size) throws IOException {
        if (exp != size) {
            throw new IOException("Size mismatch");
        }
    }

    private static int ensureFlags(int flags) throws IOException {
        if ((flags & 7) != flags) {
            throw new IOException("Invalid flags");
        }
        return flags;
    }

    public static Method[] readFrom(byte[] data) throws IOException {
        return MethodUnpacker.readFrom(data, true);
    }

    public static Method[] readFrom(byte[] data, boolean longForm) throws IOException {
        try {
            if (data == null) {
                throw new IOException("data is null");
            }
            return MethodUnpacker.readFromImpl(data, longForm);
        }
        catch (MessagePackException e) {
            throw new IOException(e);
        }
    }

    private static Method[] readFromImpl(byte[] data, boolean longForm) throws IOException {
        MessagePack.UnpackerConfig unpackerConfig = MessagePack.DEFAULT_UNPACKER_CONFIG.withStringSizeLimit(255);
        MessageUnpacker unpacker = unpackerConfig.newUnpacker(data);
        int size = MethodUnpacker.ensureMaxSize(256, unpacker.unpackArrayHeader());
        Method[] methods = new Method[size];
        for (int i = 0; i < size; ++i) {
            MethodUnpacker.ensureSize(6, unpacker.unpackArrayHeader());
            int type = unpacker.unpackInt();
            String name = unpacker.unpackString();
            int flags = MethodUnpacker.ensureFlags(unpacker.unpackInt());
            int indexed = MethodUnpacker.ensureMaxSize(64, unpacker.unpackInt());
            int inputSize = MethodUnpacker.ensureMaxSize(64, unpacker.unpackArrayHeader());
            if (indexed > inputSize) {
                throw new IOException("Invalid indexed: " + indexed);
            }
            Method.Parameter[] params = new Method.Parameter[inputSize];
            if (inputSize > 0) {
                int j;
                for (j = 0; j < indexed; ++j) {
                    params[j] = MethodUnpacker.getParameter(unpacker, false, longForm);
                }
                for (j = indexed; j < inputSize; ++j) {
                    params[j] = MethodUnpacker.getParameter(unpacker, type == 0, longForm);
                }
            }
            int output = unpacker.unpackArrayHeader();
            String outputDescriptor = "V";
            if (output != 0) {
                MethodUnpacker.ensureSize(1, output);
                output = unpacker.unpackInt();
                if (longForm) {
                    outputDescriptor = unpacker.unpackString();
                }
            }
            if (!longForm) {
                outputDescriptor = "";
            }
            if (type == 0) {
                methods[i] = Method.newFunction(name, flags, inputSize - indexed, params, output, outputDescriptor);
                continue;
            }
            if (type == 1) {
                if ("fallback".equals(name)) {
                    methods[i] = Method.newFallback();
                    continue;
                }
                throw new IOException("Invalid fallback: " + name);
            }
            if (type == 2) {
                methods[i] = Method.newEvent(name, indexed, params);
                continue;
            }
            throw new IOException("Unknown method type: " + type);
        }
        return methods;
    }

    private static Method.Parameter getParameter(MessageUnpacker unpacker, boolean optional, boolean longForm) throws IOException {
        int size = unpacker.unpackArrayHeader();
        String paramName = unpacker.unpackString();
        --size;
        String paramDescriptor = "";
        if (longForm) {
            paramDescriptor = unpacker.unpackString();
            --size;
        }
        int paramType = unpacker.unpackInt();
        --size;
        if (!unpacker.tryUnpackNil()) {
            MethodUnpacker.ensureSize(1, unpacker.unpackBinaryHeader());
            unpacker.readPayload(1);
        }
        --size;
        Method.Field[] sf = null;
        if (Method.DataType.getElement(paramType) == 8) {
            sf = MethodUnpacker.unpackStructFields(unpacker, 0);
            --size;
        }
        if (size != 0) {
            throw new IOException("Invalid param size");
        }
        return new Method.Parameter(paramName, paramDescriptor, paramType, sf, optional);
    }

    private static Method.Field[] unpackStructFields(MessageUnpacker unpacker, int depth) throws IOException {
        depth = MethodUnpacker.ensureMaxSize(4, depth + 1);
        int n = MethodUnpacker.ensureMaxSize(64, unpacker.unpackArrayHeader());
        Method.Field[] res = new Method.Field[n];
        for (int i = 0; i < n; ++i) {
            MethodUnpacker.ensureSize(3, unpacker.unpackArrayHeader());
            String name = unpacker.unpackString();
            int t = unpacker.unpackInt();
            Method.Field[] sf = null;
            if (Method.DataType.getElement(t) == 8) {
                sf = MethodUnpacker.unpackStructFields(unpacker, depth);
            } else {
                unpacker.unpackNil();
            }
            res[i] = new Method.Field(name, t, sf);
        }
        return res;
    }
}

