/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import foundation.icon.ee.util.Disposable;
import foundation.icon.ee.util.DisposableReferenceQueue;
import foundation.icon.ee.util.LinkedHashMultimap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.function.Predicate;

public abstract class MultimapCache<K, V> {
    private static final int DEFAULT_CAP = 256;
    private final DisposableReferenceQueue<V> refQueue = new DisposableReferenceQueue();
    protected final EntryMap entryMap = new EntryMap();
    private final int cap;

    public MultimapCache() {
        this(256);
    }

    public MultimapCache(int cap) {
        this.cap = cap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K k, Predicate<V> selector) {
        EntryMap entryMap = this.entryMap;
        synchronized (entryMap) {
            Entry entry = this.entryMap.remove(k, (Set<V> set) -> {
                Entry any = null;
                for (Entry ref : set) {
                    Object da;
                    Object t = da = ref != null ? (Object)ref.get() : null;
                    if (da != null) {
                        if (selector.test(da)) {
                            return ref;
                        }
                        any = ref;
                        continue;
                    }
                    if (any != null) continue;
                    any = ref;
                }
                return any;
            });
            return entry != null ? (V)entry.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v) {
        EntryMap entryMap = this.entryMap;
        synchronized (entryMap) {
            this.entryMap.put(k, this.newEntry(k, v, this.refQueue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EntryMap entryMap = this.entryMap;
        synchronized (entryMap) {
            return this.entryMap.size();
        }
    }

    public void gc() {
        this.refQueue.consumeAll();
    }

    protected Entry<V> newEntry(K k, V v, ReferenceQueue<V> q) {
        return null;
    }

    public static <K, V> MultimapCache<K, V> newWeakCache(int cap) {
        return new MultimapCache<K, V>(cap){

            @Override
            protected Entry<V> newEntry(K k, V v, ReferenceQueue<V> q) {
                return new WeakEntry(v, q, k);
            }

            class WeakEntry
            extends WeakReference<V>
            implements Entry<V> {
                private final K key;

                public WeakEntry(V referent, ReferenceQueue<? super V> q, K key) {
                    super(referent, q);
                    this.key = key;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispose() {
                    EntryMap entryMap = entryMap;
                    synchronized (entryMap) {
                        entryMap.remove(this.key, this);
                    }
                }
            }
        };
    }

    public static <K, V> MultimapCache<K, V> newSoftCache(int cap) {
        return new MultimapCache<K, V>(cap){

            @Override
            protected Entry<V> newEntry(K k, V v, ReferenceQueue<V> q) {
                return new SoftEntry(v, q, k);
            }

            class SoftEntry
            extends SoftReference<V>
            implements Entry<V> {
                private final K key;

                public SoftEntry(V referent, ReferenceQueue<? super V> q, K key) {
                    super(referent, q);
                    this.key = key;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispose() {
                    EntryMap entryMap = entryMap;
                    synchronized (entryMap) {
                        entryMap.remove(this.key, this);
                    }
                }
            }
        };
    }

    private class EntryMap
    extends LinkedHashMultimap<K, Entry<V>> {
        private EntryMap() {
        }

        @Override
        protected boolean removeEldestEntry(K key, Entry<V> value) {
            return MultimapCache.this.entryMap.size() > MultimapCache.this.cap;
        }
    }

    private static interface Entry<T>
    extends Disposable {
        public T get();
    }
}

