/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm;

import org.aion.avm.ArrayClassNameMapper;

public class ClassNameExtractor {
    public static String getOriginalClassName(String internalName) {
        if (internalName.startsWith("a.")) {
            return ClassNameExtractor.getArrayClassFromWrapper(internalName);
        }
        return ClassNameExtractor.removeInternalPrefix(internalName);
    }

    public static boolean isPostRenameClassDotStyle(String className) {
        return className.startsWith("s.") || className.startsWith("u.") || className.startsWith("p.") || className.startsWith("a.") || className.startsWith("e.") || className.startsWith("i.");
    }

    private static String removeInternalPrefix(String className) {
        if (className.startsWith("s.")) {
            return className.substring("s.".length());
        }
        if (className.startsWith("u.")) {
            return className.substring("u.".length());
        }
        if (className.startsWith("p.")) {
            return className.substring("p.".length());
        }
        return className;
    }

    private static String getArrayClassFromWrapper(String className) {
        String name;
        String arrayName = ArrayClassNameMapper.getOriginalNameFromWrapper(className.replaceAll("\\.", "/"));
        int dimension = 0;
        if (arrayName != null) {
            name = arrayName.replaceAll("/", ".");
            dimension = ClassNameExtractor.getDimension(name, '[');
        } else if (className.startsWith("a.")) {
            name = className.substring("a.".length());
            dimension = ClassNameExtractor.getDimension(name, '$');
        } else {
            throw new AssertionError((Object)"Unexpected array wrapper class name.");
        }
        String transformedTokens = new String(new char[dimension]).replace("\u0000", "[");
        return transformedTokens + ClassNameExtractor.getElementName(name.substring(dimension));
    }

    private static int getDimension(String desc, char prefix) {
        int d = 0;
        while (desc.charAt(d) == prefix) {
            ++d;
        }
        return d;
    }

    private static String getElementName(String internalName) {
        if (internalName.startsWith("L")) {
            return "L" + ClassNameExtractor.removeInternalPrefix(internalName.substring(1)) + ";";
        }
        return ClassNameExtractor.removeInternalPrefix(internalName);
    }
}

