/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import i.RuntimeAssertionError;
import org.aion.avm.ArrayRenamer;
import org.aion.avm.ArrayUtil;
import org.aion.avm.NameStyle;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.PlainTypeSuperResolver;
import org.aion.avm.core.exceptionwrapping.ExceptionWrapperNameMapper;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.CommonType;

public final class ArraySuperResolver {
    private final ClassHierarchy classHierarchy;
    private final ClassRenamer classRenamer;
    private final PlainTypeSuperResolver plainTypeSuperResolver;

    public ArraySuperResolver(ClassHierarchy classHierarchy, ClassRenamer classRenamer) {
        if (classHierarchy == null) {
            throw new NullPointerException("Cannot construct ArraySuperResolver with null class hierarchy.");
        }
        if (classRenamer == null) {
            throw new NullPointerException("Cannot construct ArraySuperResolver with null class renamer.");
        }
        this.classHierarchy = classHierarchy;
        this.classRenamer = classRenamer;
        this.plainTypeSuperResolver = new PlainTypeSuperResolver(this.classHierarchy, this.classRenamer);
    }

    public String getTightestSuperClassIfGivenArray(String type1dotName, String type2dotName) {
        boolean atLeastOneSpecialArray;
        RuntimeAssertionError.assertTrue(type1dotName != null);
        RuntimeAssertionError.assertTrue(type2dotName != null);
        boolean type1isArray = ArrayUtil.isArray(NameStyle.DOT_NAME, type1dotName);
        boolean type2isArray = ArrayUtil.isArray(NameStyle.DOT_NAME, type2dotName);
        boolean type1isSpecialArray = type1isArray && ArrayUtil.isSpecialPostRenameArray(NameStyle.DOT_NAME, type1dotName);
        boolean type2isSpecialArray = type2isArray && ArrayUtil.isSpecialPostRenameArray(NameStyle.DOT_NAME, type2dotName);
        boolean bl = atLeastOneSpecialArray = type1isSpecialArray || type2isSpecialArray;
        if (type1isArray && type2isArray) {
            return atLeastOneSpecialArray ? this.findSuperOfAtLeastOneSpecialArray(type1dotName, type2dotName) : this.findSuperOfTwoArrays(type1dotName, type2dotName);
        }
        if (type1isArray || type2isArray) {
            return atLeastOneSpecialArray ? this.findSuperOfAtLeastOneSpecialArray(type1dotName, type2dotName) : this.findSuperOfArrayAndNonArray(type1dotName, type2dotName);
        }
        return null;
    }

    private String findSuperOfAtLeastOneSpecialArray(String array1, String array2) {
        boolean array2isSpecialArray;
        boolean array1isSpecialArray = ArrayUtil.isSpecialPostRenameArray(NameStyle.DOT_NAME, array1);
        if (array1isSpecialArray ^ (array2isSpecialArray = ArrayUtil.isSpecialPostRenameArray(NameStyle.DOT_NAME, array2))) {
            return this.findSuperOfSpecialArrayAndOther(array1, array2);
        }
        String commonSuper = this.classHierarchy.getTightestCommonSuperClass(array1, array2);
        if (commonSuper == null) {
            return CommonType.I_OBJECT.dotName;
        }
        return commonSuper;
    }

    private String findSuperOfTwoArrays(String array1dotName, String array2dotName) {
        boolean array1isPreRename = this.classRenamer.isPreRename(array1dotName);
        boolean array2isPreRename = this.classRenamer.isPreRename(array2dotName);
        if (array1isPreRename && array2isPreRename) {
            return this.findSuperOfTwoPreRenameArrays(array1dotName, array2dotName);
        }
        if (!array1isPreRename && !array2isPreRename) {
            return this.findSuperOfTwoPostRenameArrays(array1dotName, array2dotName);
        }
        return CommonType.JAVA_LANG_OBJECT.dotName;
    }

    private String findSuperOfArrayAndNonArray(String type1dotName, String type2dotName) {
        String nonArrayDotName;
        String arrayDotName = ArrayUtil.isArray(NameStyle.DOT_NAME, type1dotName) ? type1dotName : type2dotName;
        String string = nonArrayDotName = arrayDotName.equals(type1dotName) ? type2dotName : type1dotName;
        if (ArrayUtil.isPreRenameArray(arrayDotName)) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (this.classRenamer.isPreRename(nonArrayDotName)) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (ExceptionWrapperNameMapper.isExceptionWrapperDotName(nonArrayDotName)) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        boolean arrayIsUnifyingType = ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, arrayDotName);
        boolean nonArrayIsInterface = this.classHierarchy.postRenameTypeIsInterface(nonArrayDotName);
        if (arrayIsUnifyingType || nonArrayIsInterface) {
            return CommonType.I_OBJECT.dotName;
        }
        return CommonType.SHADOW_OBJECT.dotName;
    }

    private String findSuperOfTwoPreRenameArrays(String array1preRename, String array2preRename) {
        boolean array1isPrimitiveArray = ArrayUtil.isPreRenamePrimitiveArray(array1preRename);
        boolean array2isPrimitiveArray = ArrayUtil.isPreRenamePrimitiveArray(array2preRename);
        if (array1isPrimitiveArray && array2isPrimitiveArray) {
            return array1preRename.equals(array2preRename) ? array1preRename : CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (!array1isPrimitiveArray && !array2isPrimitiveArray) {
            return this.findSuperOfTwoPreRenameObjectArrays(array1preRename, array2preRename);
        }
        return ArrayRenamer.prependPreRenameObjectArrayPrefix(CommonType.JAVA_LANG_OBJECT.dotName, 1);
    }

    private String findSuperOfTwoPostRenameArrays(String array1postRename, String array2postRename) {
        boolean array1isPrimitiveArray = ArrayUtil.isPostRenamePrimitiveArray(NameStyle.DOT_NAME, array1postRename);
        boolean array2isPrimitiveArray = ArrayUtil.isPostRenamePrimitiveArray(NameStyle.DOT_NAME, array2postRename);
        if (array1isPrimitiveArray && array2isPrimitiveArray) {
            return array1postRename.equals(array2postRename) ? array1postRename : CommonType.SHADOW_OBJECT.dotName;
        }
        if (!array1isPrimitiveArray && !array2isPrimitiveArray) {
            return this.findSuperOfTwoPostRenameObjectArrays(array1postRename, array2postRename);
        }
        boolean objectIsUnifyingArray = array1isPrimitiveArray ? ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, array2postRename) : ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, array1postRename);
        return objectIsUnifyingArray ? CommonType.I_OBJECT.dotName : CommonType.SHADOW_OBJECT.dotName;
    }

    private String findSuperOfTwoPostRenameObjectArrays(String array1postRename, String array2postRename) {
        int dimension2;
        int dimension1 = ArrayUtil.dimensionOfPostRenameObjectArray(NameStyle.DOT_NAME, array1postRename);
        if (dimension1 == (dimension2 = ArrayUtil.dimensionOfPostRenameObjectArray(NameStyle.DOT_NAME, array2postRename))) {
            String baseType2;
            String baseType1 = ArrayRenamer.getPostRenameObjectArrayWrapperUnderlyingTypeName(NameStyle.DOT_NAME, array1postRename);
            String superOfBases = this.plainTypeSuperResolver.getTightestSuperClassIfGivenPlainType(baseType1, baseType2 = ArrayRenamer.getPostRenameObjectArrayWrapperUnderlyingTypeName(NameStyle.DOT_NAME, array2postRename));
            RuntimeAssertionError.assertTrue(superOfBases != null);
            boolean superIsIObject = superOfBases.equals(CommonType.I_OBJECT.dotName);
            boolean array1isConcreteType = ArrayUtil.isPostRenameConcreteTypeObjectArray(NameStyle.DOT_NAME, array1postRename);
            boolean array2isConcreteType = ArrayUtil.isPostRenameConcreteTypeObjectArray(NameStyle.DOT_NAME, array2postRename);
            if (!superIsIObject && array1isConcreteType && array2isConcreteType) {
                return superOfBases.equals(CommonType.SHADOW_OBJECT.dotName) ? CommonType.SHADOW_OBJECT.dotName : ArrayRenamer.wrapAsConcreteObjectArray(NameStyle.DOT_NAME, superOfBases, dimension1);
            }
            return ArrayRenamer.wrapAsUnifyingObjectArray(NameStyle.DOT_NAME, superOfBases, dimension1);
        }
        boolean array1isUnifyingType = ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, array1postRename);
        boolean array2isUnifyingType = ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, array2postRename);
        if (array1isUnifyingType || array2isUnifyingType) {
            return CommonType.I_OBJECT.dotName;
        }
        return CommonType.SHADOW_OBJECT.dotName;
    }

    private String findSuperOfTwoPreRenameObjectArrays(String array1, String array2) {
        int dimension2;
        int dimension1 = ArrayUtil.dimensionOfPreRenameObjectArray(array1);
        if (dimension1 == (dimension2 = ArrayUtil.dimensionOfPreRenameObjectArray(array2))) {
            String baseType2;
            String baseType1 = ArrayRenamer.getPreRenameObjectArrayWrapperUnderlyingTypeName(array1);
            String superOfBases = this.plainTypeSuperResolver.getTightestSuperClassIfGivenPlainType(baseType1, baseType2 = ArrayRenamer.getPreRenameObjectArrayWrapperUnderlyingTypeName(array2));
            RuntimeAssertionError.assertTrue(superOfBases != null);
            return ArrayRenamer.prependPreRenameObjectArrayPrefix(superOfBases, dimension1);
        }
        return ArrayRenamer.prependPreRenameObjectArrayPrefix(CommonType.JAVA_LANG_OBJECT.dotName, 1);
    }

    private String findSuperOfSpecialArrayAndOther(String type1dotName, String type2dotName) {
        String otherType;
        String specialArray = ArrayUtil.isSpecialPostRenameArray(NameStyle.DOT_NAME, type1dotName) ? type1dotName : type2dotName;
        String string = otherType = specialArray.equals(type1dotName) ? type2dotName : type1dotName;
        if (this.classRenamer.isPreRename(otherType)) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (ExceptionWrapperNameMapper.isExceptionWrapperDotName(otherType)) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (ArrayUtil.isPostRenameArray(NameStyle.DOT_NAME, otherType)) {
            if (ArrayUtil.isPostRenameSingleDimensionPrimitiveArray(NameStyle.DOT_NAME, otherType)) {
                if (specialArray.equals(CommonType.ARRAY.dotName) || specialArray.equals(CommonType.I_ARRAY.dotName)) {
                    return specialArray;
                }
                if (specialArray.equals(CommonType.OBJECT_ARRAY.dotName)) {
                    return CommonType.SHADOW_OBJECT.dotName;
                }
                if (specialArray.equals(CommonType.I_OBJECT_ARRAY.dotName)) {
                    return CommonType.I_OBJECT.dotName;
                }
                throw RuntimeAssertionError.unreachable("Expected a special array type: " + specialArray);
            }
            if (ArrayUtil.isPostRenameMultiDimensionPrimitiveArray(NameStyle.DOT_NAME, otherType)) {
                if (specialArray.equals(CommonType.I_OBJECT_ARRAY.dotName) || specialArray.equals(CommonType.I_ARRAY.dotName)) {
                    return CommonType.I_OBJECT.dotName;
                }
                if (specialArray.equals(CommonType.ARRAY.dotName) || specialArray.equals(CommonType.OBJECT_ARRAY.dotName)) {
                    return CommonType.SHADOW_OBJECT.dotName;
                }
                throw RuntimeAssertionError.unreachable("Expected a special array type: " + specialArray);
            }
            if (ArrayUtil.isPostRenameConcreteTypeObjectArray(NameStyle.DOT_NAME, otherType)) {
                if (specialArray.equals(CommonType.OBJECT_ARRAY.dotName) || specialArray.equals(CommonType.I_OBJECT_ARRAY.dotName)) {
                    return specialArray;
                }
                if (specialArray.equals(CommonType.ARRAY.dotName)) {
                    return CommonType.SHADOW_OBJECT.dotName;
                }
                if (specialArray.equals(CommonType.I_ARRAY.dotName)) {
                    return CommonType.I_OBJECT.dotName;
                }
                throw RuntimeAssertionError.unreachable("Expected a special array type: " + specialArray);
            }
            if (ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, otherType)) {
                if (specialArray.equals(CommonType.I_OBJECT_ARRAY.dotName)) {
                    return specialArray;
                }
                if (specialArray.equals(CommonType.OBJECT_ARRAY.dotName) || specialArray.equals(CommonType.I_ARRAY.dotName) || specialArray.equals(CommonType.ARRAY.dotName)) {
                    return CommonType.I_OBJECT.dotName;
                }
                throw RuntimeAssertionError.unreachable("Expected a special array type: " + specialArray);
            }
            throw RuntimeAssertionError.unreachable("Expected a post-rename array: " + otherType);
        }
        boolean specialTypeIsInterface = specialArray.equals(CommonType.I_OBJECT_ARRAY.dotName) || specialArray.equals(CommonType.I_ARRAY.dotName);
        boolean otherTypeIsInterface = this.classHierarchy.postRenameTypeIsInterface(otherType);
        if (specialTypeIsInterface || otherTypeIsInterface) {
            return CommonType.I_OBJECT.dotName;
        }
        return CommonType.SHADOW_OBJECT.dotName;
    }
}

