/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import a.ByteArray;
import a.ObjectArray;
import foundation.icon.ee.io.RLPDataReader;
import foundation.icon.ee.io.RLPDataWriter;
import foundation.icon.ee.io.RLPNDataReader;
import foundation.icon.ee.io.RLPNDataWriter;
import foundation.icon.ee.types.Bytes;
import foundation.icon.ee.types.DAppRuntimeState;
import foundation.icon.ee.types.ManualRevertException;
import foundation.icon.ee.types.Result;
import foundation.icon.ee.types.Status;
import foundation.icon.ee.types.StepCost;
import foundation.icon.ee.types.Transaction;
import foundation.icon.ee.util.Crypto;
import foundation.icon.ee.util.LogMarker;
import foundation.icon.ee.util.Shadower;
import foundation.icon.ee.util.Unshadower;
import foundation.icon.ee.util.ValueCodec;
import i.GenericPredefinedException;
import i.IBlockchainRuntime;
import i.IInstrumentation;
import i.IObject;
import i.IObjectArray;
import i.IRuntimeSetup;
import i.InstrumentationHelpers;
import java.util.Map;
import java.util.Objects;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.ReentrantDAppStack;
import org.aion.avm.core.persistence.LoadedDApp;
import org.aion.parallel.TransactionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p.score.Address;
import p.score.AnyDB;
import p.score.ByteArrayObjectWriter;
import p.score.ObjectReader;
import pi.AnyDBImpl;
import pi.ObjectReaderImpl;
import pi.ObjectWriterImpl;
import s.java.lang.Boolean;
import s.java.lang.Class;
import s.java.math.BigInteger;
import score.RevertedException;
import score.UserRevertedException;

public class BlockchainRuntimeImpl
implements IBlockchainRuntime {
    private static final Logger logger = LoggerFactory.getLogger(BlockchainRuntimeImpl.class);
    private final IExternalState externalState;
    private final TransactionTask task;
    private final foundation.icon.ee.types.Address transactionSender;
    private final foundation.icon.ee.types.Address transactionDestination;
    private final Transaction tx;
    private final IRuntimeSetup thisDAppSetup;
    private final LoadedDApp dApp;
    private Address addressCache;
    private Address callerCache;
    private Address originCache;
    private Address ownerCache;
    private ByteArray transactionHashCache;
    private BigInteger valueCache;
    private BigInteger nonceCache;

    public BlockchainRuntimeImpl(IExternalState externalState, TransactionTask task, foundation.icon.ee.types.Address transactionSender, foundation.icon.ee.types.Address transactionDestination, Transaction tx, IRuntimeSetup thisDAppSetup, LoadedDApp dApp) {
        this.externalState = externalState;
        this.task = task;
        this.transactionSender = transactionSender;
        this.transactionDestination = transactionDestination;
        this.tx = tx;
        this.thisDAppSetup = thisDAppSetup;
        this.dApp = dApp;
    }

    @Override
    public ByteArray avm_getTransactionHash() {
        byte[] txHash;
        if (null == this.transactionHashCache && (txHash = this.tx.copyOfTransactionHash()) != null) {
            this.transactionHashCache = new ByteArray(txHash);
        }
        return this.transactionHashCache;
    }

    @Override
    public int avm_getTransactionIndex() {
        return this.tx.getTxIndex();
    }

    @Override
    public long avm_getTransactionTimestamp() {
        return this.tx.getTxTimestamp();
    }

    @Override
    public BigInteger avm_getTransactionNonce() {
        if (null == this.nonceCache) {
            this.nonceCache = new BigInteger(this.tx.getNonce());
        }
        return this.nonceCache;
    }

    @Override
    public Address avm_getAddress() {
        if (null == this.addressCache) {
            this.addressCache = new Address(this.transactionDestination.toByteArray());
        }
        return this.addressCache;
    }

    @Override
    public Address avm_getCaller() {
        if (null == this.callerCache && this.transactionSender != null) {
            this.callerCache = new Address(this.transactionSender.toByteArray());
        }
        return this.callerCache;
    }

    @Override
    public Address avm_getOrigin() {
        if (null == this.originCache && this.task.getOriginAddress() != null) {
            this.originCache = new Address(this.task.getOriginAddress().toByteArray());
        }
        return this.originCache;
    }

    @Override
    public Address avm_getOwner() {
        if (null == this.ownerCache) {
            this.ownerCache = new Address(this.externalState.getOwner().toByteArray());
        }
        return this.ownerCache;
    }

    @Override
    public BigInteger avm_getValue() {
        if (null == this.valueCache) {
            this.valueCache = new BigInteger(this.tx.getValue());
        }
        return this.valueCache;
    }

    @Override
    public long avm_getBlockTimestamp() {
        return this.externalState.getBlockTimestamp();
    }

    @Override
    public long avm_getBlockHeight() {
        return this.externalState.getBlockHeight();
    }

    @Override
    public BigInteger avm_getBalance(Address address) {
        Objects.requireNonNull(address, "Address can't be NULL");
        return new BigInteger(this.externalState.getBalance(new foundation.icon.ee.types.Address(address.toByteArray())));
    }

    @Override
    public IObject avm_call(Class<?> cls, BigInteger value, Address targetAddress, s.java.lang.String method, IObjectArray params) {
        if (value == null) {
            value = BigInteger.avm_ZERO;
        }
        if (method == null) {
            method = new s.java.lang.String("");
        }
        Map<String, Object[]> dataObj = Map.of("method", method.getUnderlying(), "params", this.getUnderlyingObjects(params));
        return this.messageCall(cls, value, targetAddress, "call", dataObj);
    }

    @Override
    public Address avm_deploy(Address target, ByteArray content, IObjectArray params) {
        Objects.requireNonNull(content, "Content cannot be NULL");
        if (target == null) {
            byte[] raw = new byte[21];
            raw[0] = 1;
            target = new Address(raw);
        }
        Map<String, Object[]> dataObj = Map.of("contentType", "application/java", "content", content.getUnderlying(), "params", this.getUnderlyingObjects(params));
        return (Address)this.messageCall(target.avm_getClass(), BigInteger.avm_ZERO, target, "deploy", dataObj);
    }

    private Object[] getUnderlyingObjects(IObjectArray sparams) {
        if (sparams == null) {
            sparams = new ObjectArray(0);
        }
        Object[] params = new Object[sparams.length()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = Unshadower.unshadow(sparams.get(i));
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObject messageCall(Class<?> cls, BigInteger value, Address targetAddress, String dataType, Object dataObj) {
        Result res;
        Objects.requireNonNull(targetAddress, "Destination can't be NULL");
        this.externalState.waitForCallbacks();
        IInstrumentation inst = IInstrumentation.attachedThreadInstrumentation.get();
        int hash = inst.peekNextHashCode();
        long stepLeft = inst.energyLeft();
        DAppRuntimeState rs = this.dApp.saveRuntimeState(hash, 500000);
        byte[] cid = this.externalState.getContractID();
        ReentrantDAppStack rds = this.task.getReentrantDAppStack();
        rds.getTop().setRuntimeState(this.task.getEID(), rs, cid);
        InstrumentationHelpers.temporarilyExitFrame(this.thisDAppSetup);
        ReentrantDAppStack.ReentrantState prevState = rds.getTop();
        rds.pushState();
        try {
            res = this.externalState.call(new foundation.icon.ee.types.Address(targetAddress.toByteArray()), value.getUnderlying(), stepLeft, dataType, dataObj);
        }
        finally {
            InstrumentationHelpers.returnToExecutingFrame(this.thisDAppSetup);
        }
        if (res.getStatus() == 0 && prevState != null) {
            prevState.inherit(rds.getTop());
        }
        rds.popState();
        this.task.setEID(res.getEID());
        this.task.setPrevEID(res.getPrevEID());
        DAppRuntimeState newRS = rds.getTop().getRuntimeState(this.task.getPrevEID());
        rds.getTop().removeRuntimeStatesByAddress(cid);
        assert (newRS != null);
        this.dApp.loadRuntimeState(newRS);
        this.dApp.invalidateStateCache();
        inst.forceNextHashCode(newRS.getGraph().getNextHash());
        inst.chargeEnergy(res.getStepUsed().longValue());
        int s = res.getStatus();
        if (s == 0) {
            if (cls == null) {
                return Shadower.shadow(res.getRet());
            }
            return Shadower.shadowReturnValue(res.getRet(), cls.getRealClass());
        }
        if (s == 1) {
            throw new RevertedException();
        }
        if (s == 2 || s == 3 || s == 4 || s == 6 || s == 11 || s == 15) {
            throw new IllegalArgumentException(Status.getMessage(s));
        }
        if (s == 10 || s == 13) {
            throw new GenericPredefinedException(s, Status.getMessage(s));
        }
        if (s < 32) {
            throw new RevertedException();
        }
        if (s < 1000) {
            throw new UserRevertedException(s - 32, res.getRet() == null ? null : res.getRet().toString());
        }
        throw new RevertedException();
    }

    @Override
    public void avm_revert(int code, s.java.lang.String message) {
        throw new ManualRevertException(Status.fromUserCode(code), message.getUnderlying());
    }

    @Override
    public void avm_revert(int code) {
        throw new ManualRevertException(Status.fromUserCode(code));
    }

    @Override
    public void avm_require(boolean condition, s.java.lang.String message) {
        if (!condition) {
            throw new ManualRevertException(32, message.getUnderlying());
        }
    }

    @Override
    public void avm_require(boolean condition) {
        if (!condition) {
            throw new ManualRevertException(32);
        }
    }

    @Override
    public void avm_println(s.java.lang.String message) {
        logger.trace(LogMarker.Trace, "PRT| " + (message != null ? message.toString() : "<null>"));
    }

    @Override
    public ByteArray avm_hash(s.java.lang.String alg, ByteArray data) {
        Objects.requireNonNull(alg, "Algorithm can't be NULL");
        Objects.requireNonNull(data, "Input data can't be NULL");
        return new ByteArray(Crypto.hash(alg.getUnderlying(), data.getUnderlying()));
    }

    @Override
    public boolean avm_verifySignature(s.java.lang.String alg, ByteArray msg, ByteArray sig, ByteArray pubKey) {
        Objects.requireNonNull(alg, "Algorithm can't be NULL");
        Objects.requireNonNull(msg, "Message can't be NULL");
        Objects.requireNonNull(sig, "Signature can't be NULL");
        Objects.requireNonNull(pubKey, "Public key can't be NULL");
        return Crypto.verifySignature(alg.getUnderlying(), msg.getUnderlying(), sig.getUnderlying(), pubKey.getUnderlying());
    }

    @Override
    public ByteArray avm_recoverKey(s.java.lang.String alg, ByteArray msg, ByteArray sig, boolean compressed) {
        Objects.requireNonNull(alg, "Algorithm can't be NULL");
        Objects.requireNonNull(msg, "Message can't be NULL");
        Objects.requireNonNull(sig, "Signature can't be NULL");
        return new ByteArray(Crypto.recoverKey(alg.getUnderlying(), msg.getUnderlying(), sig.getUnderlying(), compressed));
    }

    @Override
    public ByteArray avm_aggregate(s.java.lang.String type, ByteArray prevAgg, ByteArray values) {
        Objects.requireNonNull(type, "Type can't be NULL");
        Objects.requireNonNull(values, "Values can't be NULL");
        byte[] pa = null;
        if (prevAgg != null) {
            pa = prevAgg.getUnderlying();
        }
        return new ByteArray(Crypto.aggregate(type.getUnderlying(), pa, values.getUnderlying()));
    }

    @Override
    public Address avm_getAddressFromKey(ByteArray publicKey) {
        Objects.requireNonNull(publicKey, "publicKey is NULL");
        return new Address(Crypto.getAddressBytesFromKey(publicKey.getUnderlying()));
    }

    @Override
    public int avm_getFeeSharingProportion() {
        return this.externalState.getFeeSharingProportion();
    }

    @Override
    public void avm_setFeeSharingProportion(int proportion) {
        if (this.externalState.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (proportion < 0 || 100 < proportion) {
            throw new IllegalArgumentException();
        }
        this.externalState.setFeeSharingProportion(proportion);
    }

    @Override
    public AnyDB avm_newAnyDB(s.java.lang.String id, Class<?> vc) {
        return new AnyDBImpl(id, vc);
    }

    private static boolean isValidEventValue(IObject obj) {
        return obj instanceof BigInteger || obj instanceof Boolean || obj instanceof s.java.lang.String || obj instanceof ByteArray || obj instanceof Address;
    }

    @Override
    public void avm_logEvent(IObjectArray indexed, IObjectArray data) {
        if (this.externalState.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Context.logEvent indexed.len={} data.len={}", (Object)indexed.length(), (Object)data.length());
        }
        int len = 21;
        byte[][] bindexed = new byte[indexed.length()][];
        for (int i = 0; i < bindexed.length; ++i) {
            IObject v = (IObject)indexed.get(i);
            if (!BlockchainRuntimeImpl.isValidEventValue(v)) {
                throw new IllegalArgumentException();
            }
            bindexed[i] = ValueCodec.encode(v);
            len += bindexed[i].length;
            if (!logger.isTraceEnabled()) continue;
            logger.trace("indexed[{}]={}", (Object)i, (Object)(i == 0 ? new String(bindexed[i]) : Bytes.toHexString(bindexed[i])));
        }
        byte[][] bdata = new byte[data.length()][];
        for (int i = 0; i < bdata.length; ++i) {
            IObject v = (IObject)data.get(i);
            if (!BlockchainRuntimeImpl.isValidEventValue(v)) {
                throw new IllegalArgumentException();
            }
            bdata[i] = ValueCodec.encode(v);
            len += bdata[i].length;
            if (!logger.isTraceEnabled()) continue;
            logger.trace("data[{}]={}", (Object)i, (Object)Bytes.toHexString(bdata[i]));
        }
        StepCost stepCost = this.externalState.getStepCost();
        IInstrumentation.charge(stepCost.eventLog(len));
        this.externalState.event(bindexed, bdata);
    }

    @Override
    public ObjectReader avm_newByteArrayObjectReader(s.java.lang.String codec, ByteArray byteArray) {
        String c;
        String string = c = codec == null ? null : codec.getUnderlying();
        if ("RLPn".equals(c)) {
            return new ObjectReaderImpl(new RLPNDataReader(byteArray.getUnderlying()));
        }
        if ("RLP".equals(c)) {
            return new ObjectReaderImpl(new RLPDataReader(byteArray.getUnderlying()));
        }
        throw new IllegalArgumentException("bad codec");
    }

    @Override
    public ByteArrayObjectWriter avm_newByteArrayObjectWriter(s.java.lang.String codec) {
        String c;
        String string = c = codec == null ? null : codec.getUnderlying();
        if ("RLPn".equals(c)) {
            return new ObjectWriterImpl(new RLPNDataWriter());
        }
        if ("RLP".equals(c)) {
            return new ObjectWriterImpl(new RLPDataWriter());
        }
        throw new IllegalArgumentException("bad codec");
    }
}

