/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import i.RuntimeAssertionError;
import java.util.HashSet;
import java.util.Set;
import org.aion.avm.ArrayUtil;
import org.aion.avm.NameStyle;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.types.CommonType;

public final class ClassRenamer {
    public final boolean preserveDebuggability;
    private final NameStyle style;
    private final Set<String> preRenameJclExceptions;
    private final Set<String> preRenameUserClasses;
    private boolean jclClassesPermitted = true;
    private boolean apiClassesPermitted = true;
    private boolean exceptionWrappersPermitted = true;
    private boolean preciseArraysPermitted = true;
    private boolean unifyingArraysPermitted = true;
    private boolean userDefinedClassesPermitted = true;
    private final String exceptionWrapperPrefix;
    private final String postRenameApiPrefix;
    private final String preRenameApiPrefix;
    private final String shadowPrefix;
    private final String userPrefix;
    private final String apiImplPrefix;
    private static final String exceptionPostfix = "Exception";

    public ClassRenamer(boolean preserveDebuggability, NameStyle style, Set<String> jclExceptions, NameCategory jclExceptionsCategory, Set<String> userDefinedClasses, NameCategory userDefinedClassesCategory, Set<ClassCategory> prohibitedClasses) {
        String prefix;
        RuntimeAssertionError.assertTrue(style != null);
        RuntimeAssertionError.assertTrue(jclExceptions != null);
        RuntimeAssertionError.assertTrue(jclExceptionsCategory != null);
        RuntimeAssertionError.assertTrue(userDefinedClasses != null);
        RuntimeAssertionError.assertTrue(userDefinedClassesCategory != null);
        if (jclExceptionsCategory == NameCategory.POST_RENAME) {
            prefix = style == NameStyle.DOT_NAME ? "s." : "s/";
            this.preRenameJclExceptions = this.toSimplePreRenameSet(jclExceptions, prefix, style);
        } else {
            this.preRenameJclExceptions = new HashSet<String>(jclExceptions);
        }
        if (userDefinedClassesCategory == NameCategory.POST_RENAME) {
            prefix = style == NameStyle.DOT_NAME ? "u." : "u/";
            prefix = preserveDebuggability ? "" : prefix;
            this.preRenameUserClasses = this.toSimplePreRenameSet(userDefinedClasses, prefix, style);
        } else {
            this.preRenameUserClasses = new HashSet<String>(userDefinedClasses);
        }
        this.setProhibitions(prohibitedClasses);
        if (style == NameStyle.DOT_NAME) {
            this.exceptionWrapperPrefix = "e.";
            this.postRenameApiPrefix = "p.";
            this.preRenameApiPrefix = "score.";
            this.shadowPrefix = "s.";
            this.userPrefix = preserveDebuggability ? "" : "u.";
            this.apiImplPrefix = "pi.";
        } else {
            this.exceptionWrapperPrefix = "e/";
            this.postRenameApiPrefix = "p/";
            this.preRenameApiPrefix = "score/";
            this.shadowPrefix = "s/";
            this.userPrefix = preserveDebuggability ? "" : "u/";
            this.apiImplPrefix = "pi/";
        }
        this.style = style;
        this.preserveDebuggability = preserveDebuggability;
    }

    public String toPostRenameOrRejectClass(String preRenameClassName, ArrayType arrayType) {
        return this.toPostRenameInternal(preRenameClassName, arrayType, true);
    }

    public String toPostRename(String name, ArrayType arrayType) {
        return this.toPostRenameInternal(name, arrayType, false);
    }

    private String toPostRenameInternal(String preRenameClassName, ArrayType arrayType, boolean allowClassRejection) {
        RuntimeAssertionError.assertTrue(!preRenameClassName.contains(this.style == NameStyle.DOT_NAME ? "/" : "."));
        RuntimeAssertionError.assertTrue(arrayType != null);
        if (this.isPreRenameUserClass(preRenameClassName)) {
            return this.toPostRenameUserDefinedClass(preRenameClassName);
        }
        if (this.isPreRenameArray(preRenameClassName)) {
            return this.toPostRenameArray(preRenameClassName, arrayType);
        }
        if (this.isPreRenameApiClass(preRenameClassName)) {
            return this.toPostRenameApiClass(preRenameClassName);
        }
        if (this.isPreRenameJclClass(preRenameClassName)) {
            return this.toPostRenameJclClass(preRenameClassName);
        }
        if (this.isApiImplClass(preRenameClassName)) {
            return preRenameClassName;
        }
        if (allowClassRejection) {
            throw RejectedClassException.notAllowedClass(preRenameClassName);
        }
        throw RuntimeAssertionError.unreachable("Expected a pre-rename class name: " + preRenameClassName);
    }

    public String toPreRename(String postRename) {
        RuntimeAssertionError.assertTrue(!postRename.contains(this.style == NameStyle.DOT_NAME ? "/" : "."));
        if (this.isPostRenameUserClass(postRename)) {
            return this.toPreRenameUserDefinedClass(postRename);
        }
        if (this.isIObject(postRename)) {
            return this.getJavaLangObject();
        }
        if (this.isExceptionWrapper(postRename)) {
            return this.toPreRenameExceptionWrapper(postRename);
        }
        if (this.isPostRenameArray(postRename)) {
            return this.toPreRenameArray(postRename);
        }
        if (this.isPostRenameApiClass(postRename)) {
            return this.toPreRenameApiClass(postRename);
        }
        if (this.isPostRenameJclClass(postRename)) {
            return this.toPreRenameJclClass(postRename);
        }
        if (this.isApiImplClass(postRename)) {
            return postRename;
        }
        throw RuntimeAssertionError.unreachable("Expected a post-rename class name: " + postRename);
    }

    public String toExceptionWrapper(String exception) {
        RuntimeAssertionError.assertTrue(!exception.contains(this.style == NameStyle.DOT_NAME ? "/" : "."));
        return this.exceptionWrapperPrefix + exception;
    }

    public boolean isPreRename(String name) {
        RuntimeAssertionError.assertTrue(!name.contains(this.style == NameStyle.DOT_NAME ? "/" : "."));
        if (this.isPostRenameUserClass(name)) {
            return false;
        }
        return this.isPreRenameUserClass(name) || this.isPreRenameArray(name) || this.isPreRenameApiClass(name) || this.isPreRenameJclClass(name);
    }

    private String getJavaLangObject() {
        return this.style == NameStyle.DOT_NAME ? CommonType.JAVA_LANG_OBJECT.dotName : CommonType.JAVA_LANG_OBJECT.dotName.replaceAll("\\.", "/");
    }

    private String toPostRenameUserDefinedClass(String preRenameUserDefinedClass) {
        if (this.userDefinedClassesPermitted) {
            return this.userPrefix + preRenameUserDefinedClass;
        }
        throw RuntimeAssertionError.unreachable("User-defined classes are prohibited: " + preRenameUserDefinedClass);
    }

    private String toPostRenameJclClass(String preRenameJclClass) {
        if (this.jclClassesPermitted) {
            return this.shadowPrefix + preRenameJclClass;
        }
        throw RuntimeAssertionError.unreachable("JCL classes are prohibited: " + preRenameJclClass);
    }

    private String toPostRenameApiClass(String preRenameApiClass) {
        if (this.apiClassesPermitted) {
            return this.postRenameApiPrefix + preRenameApiClass;
        }
        throw RuntimeAssertionError.unreachable("Api classes are prohibited: " + preRenameApiClass);
    }

    private String toPostRenameArray(String preRenameArray, ArrayType arrayType) {
        if (arrayType == ArrayType.PRECISE_TYPE) {
            if (this.preciseArraysPermitted) {
                String arraySlashName = this.style == NameStyle.DOT_NAME ? preRenameArray.replaceAll("\\.", "/") : preRenameArray;
                String original = ArrayNameMapper.getPreciseArrayWrapperDescriptor(arraySlashName);
                return this.style == NameStyle.DOT_NAME ? original.replaceAll("/", "\\.") : original;
            }
            throw RuntimeAssertionError.unreachable("Precise-type arrays are prohibited: " + preRenameArray);
        }
        if (arrayType == ArrayType.UNIFYING_TYPE) {
            if (this.unifyingArraysPermitted) {
                String arraySlashName = this.style == NameStyle.DOT_NAME ? preRenameArray.replaceAll("\\.", "/") : preRenameArray;
                String original = ArrayNameMapper.getUnifyingArrayWrapperDescriptor(arraySlashName);
                return this.style == NameStyle.DOT_NAME ? original.replaceAll("/", "\\.") : original;
            }
            throw RuntimeAssertionError.unreachable("Unifying-type arrays are prohibited: " + preRenameArray);
        }
        throw RuntimeAssertionError.unreachable("Expected a non-array type to be passed in but got: " + preRenameArray);
    }

    private String toPreRenameUserDefinedClass(String postRenameUserDefinedClass) {
        if (this.userDefinedClassesPermitted) {
            return postRenameUserDefinedClass.substring(this.userPrefix.length());
        }
        throw RuntimeAssertionError.unreachable("User-defined classes are prohibited: " + postRenameUserDefinedClass);
    }

    private String toPreRenameJclClass(String postRenameJclClass) {
        if (this.jclClassesPermitted) {
            return postRenameJclClass.substring(this.shadowPrefix.length());
        }
        throw RuntimeAssertionError.unreachable("JCL classes are prohibited: " + postRenameJclClass);
    }

    private String toPreRenameApiClass(String postRenameApiClass) {
        if (this.apiClassesPermitted) {
            return postRenameApiClass.substring(this.postRenameApiPrefix.length());
        }
        throw RuntimeAssertionError.unreachable("Api classes are prohibited: " + postRenameApiClass);
    }

    private String toPreRenameArray(String postRenameArray) {
        if (ArrayUtil.isSpecialPostRenameArray(this.style, postRenameArray)) {
            String arrayDotName = this.style == NameStyle.DOT_NAME ? postRenameArray : postRenameArray.replaceAll("/", "\\.");
            String original = this.toPreRenameSpecialArrayDotName(arrayDotName);
            return this.style == NameStyle.DOT_NAME ? original : original.replaceAll("/", "\\.");
        }
        if (ArrayUtil.isPostRenameConcreteTypeObjectArray(this.style, postRenameArray)) {
            if (this.preciseArraysPermitted) {
                String slashName = this.style == NameStyle.DOT_NAME ? postRenameArray.replaceAll("\\.", "/") : postRenameArray;
                String original = ArrayNameMapper.getOriginalNameOf(slashName);
                return this.style == NameStyle.DOT_NAME ? original.replaceAll("/", "\\.") : original;
            }
            throw RuntimeAssertionError.unreachable("Precise-type arrays are prohibited: " + postRenameArray);
        }
        if (ArrayUtil.isPostRenameUnifyingTypeObjectArray(this.style, postRenameArray)) {
            if (this.unifyingArraysPermitted) {
                String slashName = this.style == NameStyle.DOT_NAME ? postRenameArray.replaceAll("\\.", "/") : postRenameArray;
                String original = ArrayNameMapper.getOriginalNameOf(slashName);
                return this.style == NameStyle.DOT_NAME ? original.replaceAll("/", "\\.") : original;
            }
            throw RuntimeAssertionError.unreachable("Unifying-type arrays are prohibited: " + postRenameArray);
        }
        if (ArrayUtil.isPostRenamePrimitiveArray(this.style, postRenameArray)) {
            String slashName = this.style == NameStyle.DOT_NAME ? postRenameArray.replaceAll("\\.", "/") : postRenameArray;
            String original = ArrayNameMapper.getOriginalNameOf(slashName);
            return this.style == NameStyle.DOT_NAME ? original.replaceAll("/", "\\.") : original;
        }
        throw RuntimeAssertionError.unreachable("Expected a post-rename array: " + postRenameArray);
    }

    private String toPreRenameExceptionWrapper(String exceptionWrapper) {
        if (this.exceptionWrappersPermitted) {
            return exceptionWrapper.substring(this.exceptionWrapperPrefix.length());
        }
        throw RuntimeAssertionError.unreachable("Exception wrappers are prohibited: " + exceptionWrapper);
    }

    private String toPreRenameSpecialArrayDotName(String specialArrayDotName) {
        if (specialArrayDotName.equals(CommonType.ARRAY.dotName) || specialArrayDotName.equals(CommonType.I_ARRAY.dotName)) {
            throw RuntimeAssertionError.unreachable("Ambiguous pre-rename array name, cannot convert: " + specialArrayDotName);
        }
        if (specialArrayDotName.equals(CommonType.OBJECT_ARRAY.dotName) || specialArrayDotName.equals(CommonType.I_OBJECT_ARRAY.dotName)) {
            return "[L" + CommonType.JAVA_LANG_OBJECT.dotName;
        }
        throw RuntimeAssertionError.unreachable("Expected a special handwritten array: " + specialArrayDotName);
    }

    private boolean isApiImplClass(String className) {
        return className.startsWith(this.apiImplPrefix);
    }

    private boolean isPreRenameUserClass(String className) {
        return this.preRenameUserClasses.contains(className);
    }

    private boolean isPreRenameJclClass(String className) {
        return this.isPreRenameJclNonException(className) || this.isPreRenameJclException(className);
    }

    private boolean isPreRenameApiClass(String className) {
        return className.startsWith(this.preRenameApiPrefix) && !className.endsWith(exceptionPostfix);
    }

    private boolean isPreRenameArray(String className) {
        return ArrayUtil.isPreRenameArray(className);
    }

    private boolean isPreRenameJclException(String className) {
        return this.preRenameJclExceptions.contains(className);
    }

    private boolean isPreRenameJclNonException(String className) {
        String classSlashName = this.style == NameStyle.DOT_NAME ? className.replaceAll("\\.", "/") : className;
        return NodeEnvironment.singleton.isClassFromJCL(classSlashName);
    }

    private boolean isIObject(String className) {
        String iObject = this.style == NameStyle.DOT_NAME ? CommonType.I_OBJECT.dotName : CommonType.I_OBJECT.dotName.replaceAll("\\.", "/");
        return iObject.equals(className);
    }

    private boolean isPostRenameUserClass(String className) {
        int prefixLength = Math.min(className.length(), this.userPrefix.length());
        return this.preRenameUserClasses.contains(className.substring(prefixLength));
    }

    private boolean isPostRenameJclClass(String className) {
        int prefixLength = Math.min(className.length(), this.shadowPrefix.length());
        return this.isPostRenameJclNonException(className, prefixLength) || this.isPostRenameJclException(className, prefixLength);
    }

    private boolean isPostRenameApiClass(String className) {
        return className.startsWith(this.postRenameApiPrefix);
    }

    private boolean isExceptionWrapper(String className) {
        return className.startsWith(this.exceptionWrapperPrefix);
    }

    private boolean isPostRenameArray(String className) {
        return ArrayUtil.isPostRenameArray(this.style, className);
    }

    private boolean isPostRenameJclNonException(String className, int prefixLength) {
        String classSlashName = this.style == NameStyle.DOT_NAME ? className.replaceAll("\\.", "/") : className;
        return NodeEnvironment.singleton.isClassFromJCL(classSlashName.substring(prefixLength));
    }

    private boolean isPostRenameJclException(String className, int prefixLength) {
        return this.preRenameJclExceptions.contains(className.substring(prefixLength));
    }

    private Set<String> toSimplePreRenameSet(Set<String> postRenameSet, String prefix, NameStyle outputStyle) {
        HashSet<String> preRenameSet = new HashSet<String>();
        for (String postRename : postRenameSet) {
            String preRenameName = postRename.substring(prefix.length());
            preRenameName = outputStyle == NameStyle.DOT_NAME ? preRenameName.replaceAll("/", "\\.") : preRenameName.replaceAll("\\.", "/");
            preRenameSet.add(preRenameName);
        }
        return preRenameSet;
    }

    private void setProhibitions(Set<ClassCategory> prohibitedClasses) {
        if (prohibitedClasses != null) {
            block8: for (ClassCategory prohibitedClass : prohibitedClasses) {
                switch (prohibitedClass) {
                    case JCL: {
                        this.jclClassesPermitted = false;
                        continue block8;
                    }
                    case API: {
                        this.apiClassesPermitted = false;
                        continue block8;
                    }
                    case EXCEPTION_WRAPPER: {
                        this.exceptionWrappersPermitted = false;
                        continue block8;
                    }
                    case PRECISE_ARRAY: {
                        this.preciseArraysPermitted = false;
                        continue block8;
                    }
                    case UNIFYING_ARRAY: {
                        this.unifyingArraysPermitted = false;
                        continue block8;
                    }
                    case USER: {
                        this.userDefinedClassesPermitted = false;
                        continue block8;
                    }
                }
                throw RuntimeAssertionError.unreachable("Unexpected prohibited class: " + prohibitedClass);
            }
        }
    }

    public static enum ArrayType {
        PRECISE_TYPE,
        UNIFYING_TYPE,
        NOT_ARRAY;

    }

    public static enum NameCategory {
        PRE_RENAME,
        POST_RENAME;

    }

    public static enum ClassCategory {
        JCL,
        API,
        EXCEPTION_WRAPPER,
        PRECISE_ARRAY,
        UNIFYING_ARRAY,
        USER;

    }
}

