/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.miscvisitors.StringConstantCollectorVisitor;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ConstantClassBuilder {
    private static final String kClinitName = "<clinit>";
    private static final int kClinitAccess = 8;
    private static final String kClinitDescriptor = "()V";
    private static final String kPostRenameStringDescriptor = "Ls/java/lang/String;";
    private static final String kWrapStringMethodName = "wrapAsString";
    private static final String kWrapStringMethodDescriptor = "(Ljava/lang/String;)Ls/java/lang/String;";

    public static ConstantClassInfo buildConstantClassBytecodeForClasses(String constantClassName, Collection<byte[]> rawUserClasses) {
        StringConstantCollectorVisitor stringConstantCollector = new StringConstantCollectorVisitor();
        for (byte[] bytecode : rawUserClasses) {
            new ClassToolchain.Builder(bytecode, 2).addNextVisitor(stringConstantCollector).addWriter(new ClassWriter(0)).build().runAndGetBytecode();
        }
        List<String> sortedStringConstants = stringConstantCollector.sortedStringConstants();
        return ConstantClassBuilder.generateStringConstantClass(constantClassName, sortedStringConstants);
    }

    public static ConstantClassInfo generateConstantClassForTest(String constantClassName, List<String> sortedStringConstants) {
        return ConstantClassBuilder.generateStringConstantClass(constantClassName, sortedStringConstants);
    }

    private static ConstantClassInfo generateStringConstantClass(String className, List<String> sortedStringConstants) {
        HashMap<String, CallSite> constantToFieldMap = new HashMap<String, CallSite>();
        ClassWriter out = new ClassWriter(2);
        int classVersion = 55;
        int classAccess = 2081;
        String signature = null;
        String[] interfaces = new String[]{};
        out.visit(classVersion, classAccess, className, signature, Utilities.fullyQualifiedNameToInternalName(Object.class.getName()), interfaces);
        int fieldAccess = 9;
        for (int i = 0; i < sortedStringConstants.size(); ++i) {
            String staticName = "const_" + i;
            out.visitField(fieldAccess, staticName, kPostRenameStringDescriptor, null, null);
        }
        MethodVisitor clinitVisitor = out.visitMethod(8, kClinitName, kClinitDescriptor, null, null);
        for (int i = 0; i < sortedStringConstants.size(); ++i) {
            String staticName = "const_" + i;
            String constant = sortedStringConstants.get(i);
            constantToFieldMap.put(constant, (CallSite)((Object)staticName));
            clinitVisitor.visitLdcInsn((Object)constant);
            clinitVisitor.visitMethodInsn(184, "H", kWrapStringMethodName, kWrapStringMethodDescriptor, false);
            clinitVisitor.visitFieldInsn(179, className, staticName, kPostRenameStringDescriptor);
        }
        clinitVisitor.visitInsn(177);
        clinitVisitor.visitMaxs(1, 0);
        clinitVisitor.visitEnd();
        out.visitEnd();
        byte[] bytecode = out.toByteArray();
        return new ConstantClassInfo(bytecode, Collections.unmodifiableMap(constantToFieldMap));
    }

    public static class ConstantClassInfo {
        public final byte[] bytecode;
        public final Map<String, String> constantToFieldMap;

        private ConstantClassInfo(byte[] bytecode, Map<String, String> constantToFieldMap) {
            this.bytecode = bytecode;
            this.constantToFieldMap = constantToFieldMap;
        }
    }
}

