/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import i.RuntimeAssertionError;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.exceptionwrapping.ExceptionWrapperNameMapper;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.CommonType;

public final class ExceptionWrapperSuperResolver {
    private final ClassHierarchy classHierarchy;
    private final ClassRenamer classRenamer;

    public ExceptionWrapperSuperResolver(ClassHierarchy classHierarchy, ClassRenamer classRenamer) {
        if (classHierarchy == null) {
            throw new NullPointerException("Cannot construct ExceptionWrapperSuperResolver with null class hierarchy.");
        }
        if (classRenamer == null) {
            throw new NullPointerException("Cannot construct ExceptionWrapperSuperResolver with null class renamer.");
        }
        this.classHierarchy = classHierarchy;
        this.classRenamer = classRenamer;
    }

    public String getTightestSuperClassIfGivenPlainType(String type1dotName, String type2dotName) {
        RuntimeAssertionError.assertTrue(type1dotName != null);
        RuntimeAssertionError.assertTrue(type2dotName != null);
        boolean type1isExceptionWrapper = ExceptionWrapperNameMapper.isExceptionWrapperDotName(type1dotName);
        boolean type2isExceptionWrapper = ExceptionWrapperNameMapper.isExceptionWrapperDotName(type2dotName);
        if (type1isExceptionWrapper && type2isExceptionWrapper) {
            return this.findSuperOfTwoExceptionWrappers(type1dotName, type2dotName);
        }
        if (type1isExceptionWrapper || type2isExceptionWrapper) {
            return this.findSuperOfOneExceptionWrapperOneNonExceptionWrapper(type1dotName, type2dotName);
        }
        return null;
    }

    private String findSuperOfTwoExceptionWrappers(String wrapper1, String wrapper2) {
        String unwrapped2;
        String unwrapped1 = this.classRenamer.toPreRename(wrapper1);
        String unwrappedSuper = this.classHierarchy.getTightestCommonSuperClass(unwrapped1, unwrapped2 = this.classRenamer.toPreRename(wrapper2));
        if (unwrappedSuper == null) {
            return CommonType.JAVA_LANG_THROWABLE.dotName;
        }
        return this.classRenamer.toExceptionWrapper(unwrappedSuper);
    }

    private String findSuperOfOneExceptionWrapperOneNonExceptionWrapper(String type1dotName, String type2dotName) {
        String otherType;
        String exceptionWrapper = ExceptionWrapperNameMapper.isExceptionWrapperDotName(type1dotName) ? type1dotName : type2dotName;
        String string = otherType = exceptionWrapper.equals(type1dotName) ? type2dotName : type1dotName;
        if (this.classRenamer.isPreRename(otherType)) {
            String postRenameOther = this.classRenamer.toPostRename(otherType, ClassRenamer.ArrayType.PRECISE_TYPE);
            if (this.classHierarchy.isDescendantOfClass(postRenameOther, CommonType.SHADOW_THROWABLE.dotName)) {
                return CommonType.JAVA_LANG_THROWABLE.dotName;
            }
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        return CommonType.JAVA_LANG_OBJECT.dotName;
    }
}

