/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import a.Array;
import a.ArrayElement;
import a.BooleanArray;
import a.ByteArray;
import a.CharArray;
import a.DoubleArray;
import a.FloatArray;
import a.IArray;
import a.IntArray;
import a.LongArray;
import a.ObjectArray;
import a.ShortArray;
import e.s.java.lang.Throwable;
import i.ConstantsHolder;
import i.FrameContext;
import i.IInstrumentation;
import i.InstrumentationHelpers;
import i.InternedClasses;
import i.OutOfEnergyException;
import i.RuntimeAssertionError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aion.avm.core.classgeneration.CommonGenerators;
import org.aion.avm.core.classloading.AvmClassLoader;
import org.aion.avm.core.classloading.AvmSharedClassLoader;
import org.aion.avm.core.dappreading.LoadedJar;
import org.aion.avm.core.instrument.JCLAndAPIHeapInstanceSize;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.ClassHierarchyBuilder;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.ClassInformationFactory;
import org.aion.avm.core.util.MethodDescriptorCollector;
import org.aion.avm.utilities.Utilities;
import p.score.Address;
import p.score.ArrayDB;
import p.score.BranchDB;
import p.score.ByteArrayObjectWriter;
import p.score.Context;
import p.score.DictDB;
import p.score.ObjectReader;
import p.score.ObjectWriter;
import p.score.VarDB;
import pi.UnmodifiableArrayList;
import pi.UnmodifiableArrayMap;
import s.java.io.Serializable;
import s.java.lang.Appendable;
import s.java.lang.AssertionError;
import s.java.lang.Boolean;
import s.java.lang.Byte;
import s.java.lang.CharSequence;
import s.java.lang.Character;
import s.java.lang.Cloneable;
import s.java.lang.Comparable;
import s.java.lang.Double;
import s.java.lang.Enum;
import s.java.lang.EnumConstantNotPresentException;
import s.java.lang.Error;
import s.java.lang.Exception;
import s.java.lang.Float;
import s.java.lang.Integer;
import s.java.lang.Iterable;
import s.java.lang.Long;
import s.java.lang.Math;
import s.java.lang.Number;
import s.java.lang.Object;
import s.java.lang.Runnable;
import s.java.lang.RuntimeException;
import s.java.lang.Short;
import s.java.lang.StrictMath;
import s.java.lang.StringBuffer;
import s.java.lang.StringBuilder;
import s.java.lang.System;
import s.java.lang.TypeNotPresentException;
import s.java.lang.Void;
import s.java.lang.invoke.LambdaMetafactory;
import s.java.lang.invoke.StringConcatFactory;
import s.java.math.BigDecimal;
import s.java.math.BigInteger;
import s.java.math.MathContext;
import s.java.math.RoundingMode;
import s.java.util.Arrays;
import s.java.util.Collection;
import s.java.util.Iterator;
import s.java.util.ListIterator;
import s.java.util.Map;
import s.java.util.NoSuchElementException;
import s.java.util.concurrent.TimeUnit;
import s.java.util.function.Function;
import s.score.RevertedException;
import s.score.UserRevertException;
import s.score.UserRevertedException;

public class NodeEnvironment {
    public static final NodeEnvironment singleton = new NodeEnvironment();
    private final AvmSharedClassLoader sharedClassLoader;
    private final Map<java.lang.Integer, Object> constantMap;
    private final Class<?>[] shadowApiClasses;
    private final Class<?>[] shadowClasses;
    private final Set<String> jclClassNames;
    public final Map<String, java.lang.Integer> preRenameRuntimeObjectSizeMap;
    public final Map<String, java.lang.Integer> postRenameRuntimeObjectSizeMap;
    public final Map<String, List<String>> shadowClassSlashNameMethodDescriptorMap;
    private final ClassHierarchy classHierarchy;

    private NodeEnvironment() {
        Map<String, byte[]> generatedShadowJDK = CommonGenerators.generateShadowJDK();
        this.sharedClassLoader = new AvmSharedClassLoader(generatedShadowJDK);
        try {
            this.shadowApiClasses = new Class[]{Address.class, ArrayDB.class, BranchDB.class, ByteArrayObjectWriter.class, Context.class, DictDB.class, ObjectReader.class, ObjectWriter.class, VarDB.class};
            Class[] arrayWrapperClasses = new Class[]{IArray.class, Array.class, ArrayElement.class, BooleanArray.class, ByteArray.class, CharArray.class, DoubleArray.class, FloatArray.class, IntArray.class, LongArray.class, ObjectArray.class, ShortArray.class};
            Class[] exceptionWrapperClasses = new Class[]{Throwable.class};
            this.shadowClasses = new Class[]{AssertionError.class, Boolean.class, Byte.class, Character.class, CharSequence.class, s.java.lang.Class.class, Comparable.class, Double.class, Enum.class, EnumConstantNotPresentException.class, Error.class, Exception.class, Float.class, Integer.class, Iterable.class, Long.class, Math.class, Number.class, Object.class, Runnable.class, RuntimeException.class, Short.class, StrictMath.class, s.java.lang.String.class, StringBuffer.class, StringBuilder.class, System.class, s.java.lang.Throwable.class, TypeNotPresentException.class, Appendable.class, Cloneable.class, LambdaMetafactory.class, StringConcatFactory.class, Void.class, BigDecimal.class, BigInteger.class, MathContext.class, RoundingMode.class, Arrays.class, Collection.class, Iterator.class, ListIterator.class, s.java.util.Map.class, Map.Entry.class, NoSuchElementException.class, s.java.util.Set.class, s.java.util.List.class, Function.class, TimeUnit.class, Serializable.class, RevertedException.class, UserRevertedException.class, UserRevertException.class};
            this.jclClassNames = new HashSet<String>();
            this.jclClassNames.addAll(NodeEnvironment.loadShadowClasses(NodeEnvironment.class.getClassLoader(), this.shadowClasses));
            this.jclClassNames.addAll(Stream.of(CommonGenerators.kExceptionClassNames).map(Utilities::fullyQualifiedNameToInternalName).collect(Collectors.toList()));
            this.jclClassNames.add("java/lang/invoke/MethodHandles");
            this.jclClassNames.add("java/lang/invoke/MethodHandle");
            this.jclClassNames.add("java/lang/invoke/MethodType");
            this.jclClassNames.add("java/lang/invoke/CallSite");
            this.jclClassNames.add("java/lang/invoke/MethodHandles$Lookup");
            this.sharedClassLoader.putIntoDynamicCache(arrayWrapperClasses);
            this.sharedClassLoader.putIntoStaticCache(this.shadowClasses);
            this.sharedClassLoader.putIntoStaticCache(this.shadowApiClasses);
            this.sharedClassLoader.putIntoStaticCache(exceptionWrapperClasses);
            this.sharedClassLoader.finishInitialization();
        }
        catch (ClassNotFoundException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        this.constantMap = Collections.unmodifiableMap(ConstantsHolder.getConstants());
        RuntimeAssertionError.assertTrue(this.constantMap.size() == 34);
        Map<String, java.lang.Integer> rtObjectSizeMap = this.computeRuntimeObjectSizes();
        RuntimeAssertionError.assertTrue(rtObjectSizeMap.size() == 105);
        HashMap shadowObjectSizeMap = new HashMap();
        HashMap apiObjectSizeMap = new HashMap();
        HashMap preRenameObjectSizes = new HashMap();
        HashMap postRenameObjectSizes = new HashMap();
        rtObjectSizeMap.forEach((k, v) -> {
            if (k.startsWith("s/")) {
                shadowObjectSizeMap.put(k.substring("s/".length()), v);
                postRenameObjectSizes.put(k, v);
            }
            if (k.startsWith("p/")) {
                apiObjectSizeMap.put(k, v);
                preRenameObjectSizes.put(k.substring("p/".length()), v);
            }
        });
        preRenameObjectSizes.putAll(shadowObjectSizeMap);
        postRenameObjectSizes.putAll(apiObjectSizeMap);
        this.preRenameRuntimeObjectSizeMap = Collections.unmodifiableMap(preRenameObjectSizes);
        this.postRenameRuntimeObjectSizeMap = Collections.unmodifiableMap(postRenameObjectSizes);
        this.shadowClassSlashNameMethodDescriptorMap = Collections.unmodifiableMap(this.getShadowClassSlashNameMethodDescriptorMap());
        this.classHierarchy = this.buildJCLAndAPIClassHierarchy();
    }

    public static NodeEnvironment getInstance() {
        return singleton;
    }

    public AvmClassLoader createInvocationClassLoader(Map<String, byte[]> finalContractClasses) {
        return new AvmClassLoader(this.sharedClassLoader, finalContractClasses);
    }

    public Class<?> loadSharedClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.sharedClassLoader);
    }

    public boolean isClassFromSharedLoader(Class<?> clazz) {
        return this.sharedClassLoader == clazz.getClassLoader();
    }

    public boolean isClassFromJCL(String classNameSlash) {
        return this.jclClassNames.contains(classNameSlash);
    }

    public List<String> getJclSlashClassNames() {
        return new ArrayList<String>(this.jclClassNames);
    }

    public Map<java.lang.Integer, Object> getConstantMap() {
        return this.constantMap;
    }

    private static Set<String> loadShadowClasses(ClassLoader loader, Class<?>[] shadowClasses) throws ClassNotFoundException {
        IInstrumentation instrumentation = new IInstrumentation(){

            @Override
            public void chargeEnergy(long cost) throws OutOfEnergyException {
            }

            @Override
            public void chargeEnergy(int cost) throws OutOfEnergyException {
            }

            @Override
            public boolean tryChargeEnergy(int cost) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public long energyLeft() {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public <T> s.java.lang.Class<T> wrapAsClass(Class<T> input) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public int getNextHashCodeAndIncrement() {
                return java.lang.Integer.MIN_VALUE;
            }

            @Override
            public void bootstrapOnly() {
            }

            @Override
            public s.java.lang.String wrapAsString(String input) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public Object unwrapThrowable(java.lang.Throwable t) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public java.lang.Throwable wrapAsThrowable(Object arg) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public int getCurStackSize() {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public int getCurStackDepth() {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public void enterMethod(int frameSize) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public void exitMethod(int frameSize) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public void enterCatchBlock(int depth, int size) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public int peekNextHashCode() {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public void forceNextHashCode(int nextHashCode) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public void enterNewFrame(ClassLoader contractLoader, long energyLeft, int nextHashCode, InternedClasses classWrappers, FrameContext frameContext) {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public void exitCurrentFrame() {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }

            @Override
            public boolean isLoadedByCurrentClassLoader(Class<?> userClass) {
                throw RuntimeAssertionError.unreachable("Not expected here.");
            }

            @Override
            public FrameContext getFrameContext() {
                throw RuntimeAssertionError.unreachable("Nobody should be calling this");
            }
        };
        InstrumentationHelpers.attachThread(instrumentation);
        Set<String> loadedClassNames = NodeEnvironment.loadAndInitializeClasses(loader, shadowClasses);
        NodeEnvironment.loadAndInitializeClasses(loader, UnmodifiableArrayMap.class, UnmodifiableArrayList.class);
        InstrumentationHelpers.detachThread(instrumentation);
        return loadedClassNames;
    }

    private static Set<String> loadAndInitializeClasses(ClassLoader loader, Class<?> ... classes) throws ClassNotFoundException {
        HashSet<String> classNames = new HashSet<String>();
        boolean initialize = true;
        for (Class<?> clazz : classes) {
            Class<?> instance = Class.forName(clazz.getName(), initialize, loader);
            RuntimeAssertionError.assertTrue(clazz == instance);
            String className = Utilities.fullyQualifiedNameToInternalName(clazz.getName());
            classNames.add(className.substring("s/".length()));
        }
        return classNames;
    }

    public ClassHierarchy deepCopyOfClassHierarchy() {
        RuntimeAssertionError.assertTrue(this.classHierarchy != null);
        return this.classHierarchy.deepCopy();
    }

    private Map<String, java.lang.Integer> computeRuntimeObjectSizes() {
        ArrayList classNames = new ArrayList();
        classNames.addAll(java.util.Arrays.stream(this.shadowApiClasses).map(c -> Utilities.fullyQualifiedNameToInternalName(c.getName())).collect(Collectors.toList()));
        classNames.addAll(java.util.Arrays.stream(this.shadowClasses).map(c -> Utilities.fullyQualifiedNameToInternalName(c.getName())).collect(Collectors.toList()));
        HashMap<String, java.lang.Integer> objectHeapSizeMap = new HashMap<String, java.lang.Integer>();
        for (String name2 : classNames) {
            objectHeapSizeMap.put(name2, JCLAndAPIHeapInstanceSize.getAllocationSizeForJCLAndAPISlashClass(name2));
        }
        Stream.of(CommonGenerators.kExceptionClassNames).filter(s -> !CommonGenerators.kHandWrittenExceptionClassNames.contains(s)).map(name -> Utilities.fullyQualifiedNameToInternalName("s." + name)).forEach(s -> objectHeapSizeMap.put((String)s, JCLAndAPIHeapInstanceSize.getAllocationSizeForGeneratedExceptionSlashClass()));
        return objectHeapSizeMap;
    }

    private ClassHierarchy buildJCLAndAPIClassHierarchy() {
        HashMap<String, byte[]> classBytesByQualifiedNames = new HashMap<String, byte[]>();
        String mainClassName = "java.lang.Object";
        ArrayList classes = new ArrayList();
        classes.addAll(java.util.Arrays.asList(this.shadowApiClasses));
        classes.addAll(java.util.Arrays.asList(this.shadowClasses));
        for (Class clazz : classes) {
            try {
                String name = clazz.getName();
                InputStream bytecode = clazz.getClassLoader().getResourceAsStream(name.replaceAll("\\.", "/") + ".class");
                classBytesByQualifiedNames.put(name, bytecode.readAllBytes());
            }
            catch (IOException e) {
                RuntimeAssertionError.unexpected(e);
            }
        }
        LoadedJar runtimeJar = new LoadedJar(classBytesByQualifiedNames, mainClassName);
        ClassInformationFactory classInformationFactory = new ClassInformationFactory();
        Set<ClassInformation> classInfos = classInformationFactory.fromPostRenameJar(runtimeJar);
        return new ClassHierarchyBuilder().addPostRenameNonUserDefinedClasses(classInfos).build();
    }

    private Map<String, List<String>> getShadowClassSlashNameMethodDescriptorMap() {
        try {
            return MethodDescriptorCollector.getClassNameMethodDescriptorMap(this.getJclSlashClassNames(), this.sharedClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }
}

