/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import foundation.icon.ee.score.Loader;
import foundation.icon.ee.types.DAppRuntimeState;
import i.RuntimeAssertionError;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aion.avm.core.persistence.LoadedDApp;
import org.aion.avm.core.util.ByteArrayWrapper;

public class ReentrantDAppStack {
    private final Deque<ReentrantState> stack = new ArrayDeque<ReentrantState>();
    private final Map<ByteArrayWrapper, LoadedDAppInfo> dAppCache = new HashMap<ByteArrayWrapper, LoadedDAppInfo>();

    public void pushState(ReentrantState state) {
        RuntimeAssertionError.assertTrue(null != state);
        this.stack.push(state);
        assert (state.dApp != null);
        assert (state.contractID != null);
        assert (state.codeID != null);
        this.dAppCache.put(new ByteArrayWrapper(state.contractID), new LoadedDAppInfo(state.dApp, state.codeID));
    }

    public void pushState() {
        this.stack.push(new ReentrantState());
    }

    public ReentrantState tryShareState(byte[] contractID) {
        RuntimeAssertionError.assertTrue(null != contractID);
        ReentrantState foundState = null;
        for (ReentrantState state : this.stack) {
            if (!Arrays.equals(contractID, state.contractID)) continue;
            foundState = state;
            break;
        }
        return foundState;
    }

    public ReentrantState popState() {
        return this.stack.isEmpty() ? null : this.stack.pop();
    }

    public DAppRuntimeState getRuntimeState(int eid) {
        for (ReentrantState reentrantState : this.stack) {
            DAppRuntimeState rs = reentrantState.getRuntimeState(eid);
            if (rs == null) continue;
            return rs;
        }
        return null;
    }

    public ReentrantState getTop() {
        return this.stack.peekFirst();
    }

    public LoadedDApp tryGetLoadedDApp(byte[] contractID) {
        LoadedDAppInfo dAppInfo = this.dAppCache.get(new ByteArrayWrapper(contractID));
        return dAppInfo != null ? dAppInfo.getLoadedDApp() : null;
    }

    public void cacheDApp(LoadedDApp dApp, byte[] contractID, String codeID) {
        this.dAppCache.put(new ByteArrayWrapper(contractID), new LoadedDAppInfo(dApp, codeID));
    }

    public void unloadDApps(Loader loader) {
        for (Map.Entry<ByteArrayWrapper, LoadedDAppInfo> e : this.dAppCache.entrySet()) {
            loader.unload(e.getValue().getCodeID(), e.getValue().getLoadedDApp());
        }
    }

    static class SaveItem {
        private final DAppRuntimeState runtimeState;
        private final byte[] contractID;

        public SaveItem(DAppRuntimeState runtimeState, byte[] contractID) {
            this.runtimeState = runtimeState;
            this.contractID = contractID;
        }

        public DAppRuntimeState getRuntimeState() {
            return this.runtimeState;
        }

        public byte[] getContractID() {
            return this.contractID;
        }
    }

    public static class ReentrantState {
        public final LoadedDApp dApp;
        public final byte[] contractID;
        public final String codeID;
        private final Map<Integer, SaveItem> saveItems = new HashMap<Integer, SaveItem>();

        public ReentrantState() {
            this.dApp = null;
            this.contractID = null;
            this.codeID = null;
        }

        public ReentrantState(LoadedDApp dApp, byte[] contractID, String codeID) {
            this.dApp = dApp;
            this.contractID = contractID;
            this.codeID = codeID;
        }

        public DAppRuntimeState getRuntimeState(int eid) {
            SaveItem saveItem = this.saveItems.get(eid);
            if (saveItem == null) {
                return null;
            }
            return saveItem.getRuntimeState();
        }

        public void setRuntimeState(int eid, DAppRuntimeState rs, byte[] contractID) {
            this.saveItems.put(eid, new SaveItem(rs, contractID));
        }

        public void removeRuntimeStatesByAddress(byte[] contractID) {
            this.saveItems.entrySet().removeIf(si -> Arrays.equals(((SaveItem)si.getValue()).getContractID(), contractID));
        }

        void inherit(ReentrantState s) {
            this.saveItems.putAll(s.saveItems);
        }
    }

    private static class LoadedDAppInfo {
        private final LoadedDApp loadedDApp;
        private final String codeID;

        public LoadedDAppInfo(LoadedDApp loadedDApp, String codeID) {
            this.loadedDApp = loadedDApp;
            this.codeID = codeID;
        }

        public LoadedDApp getLoadedDApp() {
            return this.loadedDApp;
        }

        public String getCodeID() {
            return this.codeID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoadedDAppInfo that = (LoadedDAppInfo)o;
            return this.loadedDApp.equals(that.loadedDApp) && this.codeID.equals(that.codeID);
        }

        public int hashCode() {
            return Objects.hash(this.loadedDApp, this.codeID);
        }
    }
}

