/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import i.RuntimeAssertionError;
import org.aion.avm.core.ArraySuperResolver;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.ExceptionWrapperSuperResolver;
import org.aion.avm.core.PlainTypeSuperResolver;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassWriter;

public class TypeAwareClassWriter
extends ClassWriter {
    private final ArraySuperResolver arraySuperResolver;
    private final ExceptionWrapperSuperResolver exceptionWrapperSuperResolver;
    private final PlainTypeSuperResolver plainTypeSuperResolver;

    public TypeAwareClassWriter(int flags, ClassHierarchy hierarchy, ClassRenamer classRenamer) {
        super(flags);
        this.arraySuperResolver = new ArraySuperResolver(hierarchy, classRenamer);
        this.exceptionWrapperSuperResolver = new ExceptionWrapperSuperResolver(hierarchy, classRenamer);
        this.plainTypeSuperResolver = new PlainTypeSuperResolver(hierarchy, classRenamer);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        String type2dotName;
        String type1dotName = Utilities.internalNameToFullyQualifiedName(type1);
        String commonSuper = this.exceptionWrapperSuperResolver.getTightestSuperClassIfGivenPlainType(type1dotName, type2dotName = Utilities.internalNameToFullyQualifiedName(type2));
        if (commonSuper != null) {
            return Utilities.fullyQualifiedNameToInternalName(commonSuper);
        }
        commonSuper = this.arraySuperResolver.getTightestSuperClassIfGivenArray(type1dotName, type2dotName);
        if (commonSuper != null) {
            return Utilities.fullyQualifiedNameToInternalName(commonSuper);
        }
        commonSuper = this.plainTypeSuperResolver.getTightestSuperClassIfGivenPlainType(type1dotName, type2dotName);
        RuntimeAssertionError.assertTrue(commonSuper != null);
        return Utilities.fullyQualifiedNameToInternalName(commonSuper);
    }
}

