/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.arraywrapping;

import a.BooleanArray;
import a.ByteArray;
import i.IObjectArray;
import i.RuntimeAssertionError;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.aion.avm.core.arraywrapping.ArrayWrappingInterpreter;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

class ArraysRequiringAnalysisMethodNode
extends MethodNode {
    private final ClassHierarchy hierarchy;
    private String className;
    private MethodVisitor mv;

    public ArraysRequiringAnalysisMethodNode(int access, String name, String descriptor, String signature, String[] exceptions, MethodVisitor mv, String className, ClassHierarchy hierarchy) {
        super(458752, access, name, descriptor, signature, exceptions);
        this.className = className;
        this.mv = mv;
        this.hierarchy = hierarchy;
    }

    public void visitEnd() {
        AbstractInsnNode[] insns;
        Frame[] frames = null;
        if (this.instructions.size() > 0) {
            try {
                Analyzer analyzer = new Analyzer((Interpreter)new ArrayWrappingInterpreter(this.hierarchy));
                analyzer.analyze(this.className, (MethodNode)this);
                frames = analyzer.getFrames();
            }
            catch (AnalyzerException e) {
                throw new RejectedClassException("Something went wrong when trying to analyze a wrapped array: " + e.getMessage());
            }
        }
        if (null != (insns = this.instructions.toArray()) && null != frames) {
            RuntimeAssertionError.assertTrue(insns.length == frames.length);
        }
        for (int i = 0; i < insns.length; ++i) {
            MethodInsnNode invokeVNode;
            TypeInsnNode checkcastNode;
            MethodInsnNode invokeVNode2;
            String elementType;
            String targetDesc;
            BasicValue t;
            AbstractInsnNode insn = insns[i];
            Frame f = frames[i];
            if (insn.getOpcode() == 50) {
                f.pop();
                t = (BasicValue)f.pop();
                targetDesc = t.toString();
                elementType = ArrayNameMapper.getElementType(targetDesc);
                invokeVNode2 = new MethodInsnNode(185, Utilities.fullyQualifiedNameToInternalName(IObjectArray.class.getName()), "get", "(I)Ljava/lang/Object;", true);
                checkcastNode = new TypeInsnNode(192, elementType);
                this.instructions.insert(insn, (AbstractInsnNode)checkcastNode);
                this.instructions.insert(insn, (AbstractInsnNode)invokeVNode2);
                this.instructions.remove(insn);
            }
            if (insn.getOpcode() == 83) {
                f.pop();
                f.pop();
                t = (BasicValue)f.pop();
                targetDesc = t.toString();
                elementType = ArrayNameMapper.getElementType(targetDesc);
                invokeVNode2 = new MethodInsnNode(185, Utilities.fullyQualifiedNameToInternalName(IObjectArray.class.getName()), "set", "(ILjava/lang/Object;)V", true);
                checkcastNode = new TypeInsnNode(192, elementType);
                this.instructions.insert(insn, (AbstractInsnNode)invokeVNode2);
                this.instructions.insert(insn, (AbstractInsnNode)checkcastNode);
                this.instructions.remove(insn);
            }
            if (insn.getOpcode() == 51) {
                f.pop();
                t = (BasicValue)f.pop();
                targetDesc = t.toString();
                invokeVNode = targetDesc.equals("[Z") ? new MethodInsnNode(182, Utilities.fullyQualifiedNameToInternalName(BooleanArray.class.getName()), "get", "(I)Z", false) : new MethodInsnNode(182, Utilities.fullyQualifiedNameToInternalName(ByteArray.class.getName()), "get", "(I)B", false);
                this.instructions.insert(insn, (AbstractInsnNode)invokeVNode);
                this.instructions.remove(insn);
            }
            if (insn.getOpcode() != 84) continue;
            f.pop();
            f.pop();
            t = (BasicValue)f.pop();
            targetDesc = t.toString();
            invokeVNode = targetDesc.equals("[Z") ? new MethodInsnNode(182, Utilities.fullyQualifiedNameToInternalName(BooleanArray.class.getName()), "set", "(IZ)V", false) : new MethodInsnNode(182, Utilities.fullyQualifiedNameToInternalName(ByteArray.class.getName()), "set", "(IB)V", false);
            this.instructions.insert(insn, (AbstractInsnNode)invokeVNode);
            this.instructions.remove(insn);
        }
        this.accept(this.mv);
    }
}

