/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.arraywrapping;

import a.BooleanArray;
import a.ByteArray;
import a.CharArray;
import a.DoubleArray;
import a.FloatArray;
import a.IArray;
import a.IntArray;
import a.LongArray;
import a.ShortArray;
import i.RuntimeAssertionError;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

class ArraysWithKnownTypesAdapter
extends GeneratorAdapter
implements Opcodes {
    private static Pattern PRIMITIVE_ARRAY_FORMAT = Pattern.compile("[\\$\\[]+[IJZBSDFC]");
    private Type typeA = Type.getType(IArray.class);
    private Type typeBA = Type.getType(ByteArray.class);
    private Type typeZA = Type.getType(BooleanArray.class);
    private Type typeCA = Type.getType(CharArray.class);
    private Type typeDA = Type.getType(DoubleArray.class);
    private Type typeFA = Type.getType(FloatArray.class);
    private Type typeIA = Type.getType(IntArray.class);
    private Type typeLA = Type.getType(LongArray.class);
    private Type typeSA = Type.getType(ShortArray.class);
    private static final Set<String> SHADOW_JDK_ENUM_DESC = Set.of(new String[]{"()[Ls/java/math/RoundingMode;", "()[Ls/java/util/concurrent/TimeUnit;"});

    ArraysWithKnownTypesAdapter(MethodVisitor mv, int access, String name, String desc) {
        super(458752, mv, access, name, desc);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 52: {
                Method m = Method.getMethod((String)"char get(int)");
                this.invokeVirtual(this.typeCA, m);
                break;
            }
            case 49: {
                Method m = Method.getMethod((String)"double get(int)");
                this.invokeVirtual(this.typeDA, m);
                break;
            }
            case 48: {
                Method m = Method.getMethod((String)"float get(int)");
                this.invokeVirtual(this.typeFA, m);
                break;
            }
            case 46: {
                Method m = Method.getMethod((String)"int get(int)");
                this.invokeVirtual(this.typeIA, m);
                break;
            }
            case 47: {
                Method m = Method.getMethod((String)"long get(int)");
                this.invokeVirtual(this.typeLA, m);
                break;
            }
            case 53: {
                Method m = Method.getMethod((String)"short get(int)");
                this.invokeVirtual(this.typeSA, m);
                break;
            }
            case 85: {
                Method m = Method.getMethod((String)"void set(int, char)");
                this.invokeVirtual(this.typeCA, m);
                break;
            }
            case 82: {
                Method m = Method.getMethod((String)"void set(int, double)");
                this.invokeVirtual(this.typeDA, m);
                break;
            }
            case 81: {
                Method m = Method.getMethod((String)"void set(int, float)");
                this.invokeVirtual(this.typeFA, m);
                break;
            }
            case 79: {
                Method m = Method.getMethod((String)"void set(int, int)");
                this.invokeVirtual(this.typeIA, m);
                break;
            }
            case 80: {
                Method m = Method.getMethod((String)"void set(int, long)");
                this.invokeVirtual(this.typeLA, m);
                break;
            }
            case 86: {
                Method m = Method.getMethod((String)"void set(int, short)");
                this.invokeVirtual(this.typeSA, m);
                break;
            }
            case 190: {
                Method m = Method.getMethod((String)"int length()");
                this.invokeInterface(this.typeA, m);
                break;
            }
            case 50: {
                throw RuntimeAssertionError.unreachable("Primitive array wrapping adapter catch AALOAD");
            }
            case 83: {
                throw RuntimeAssertionError.unreachable("Primitive array wrapping adapter catch AASTORE");
            }
            default: {
                this.mv.visitInsn(opcode);
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            switch (operand) {
                case 4: {
                    Method m = Method.getMethod((String)"a.BooleanArray initArray(int)");
                    this.invokeStatic(this.typeZA, m);
                    break;
                }
                case 8: {
                    Method m = Method.getMethod((String)"a.ByteArray initArray(int)");
                    this.invokeStatic(this.typeBA, m);
                    break;
                }
                case 9: {
                    Method m = Method.getMethod((String)"a.ShortArray initArray(int)");
                    this.invokeStatic(this.typeSA, m);
                    break;
                }
                case 10: {
                    Method m = Method.getMethod((String)"a.IntArray initArray(int)");
                    this.invokeStatic(this.typeIA, m);
                    break;
                }
                case 11: {
                    Method m = Method.getMethod((String)"a.LongArray initArray(int)");
                    this.invokeStatic(this.typeLA, m);
                    break;
                }
                case 5: {
                    Method m = Method.getMethod((String)"a.CharArray initArray(int)");
                    this.invokeStatic(this.typeCA, m);
                    break;
                }
                case 6: {
                    Method m = Method.getMethod((String)"a.FloatArray initArray(int)");
                    this.invokeStatic(this.typeFA, m);
                    break;
                }
                case 7: {
                    Method m = Method.getMethod((String)"a.DoubleArray initArray(int)");
                    this.invokeStatic(this.typeDA, m);
                    break;
                }
                default: {
                    this.mv.visitIntInsn(opcode, operand);
                    break;
                }
            }
        } else {
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 189: {
                String wName = type.startsWith("[") ? ArrayNameMapper.getPreciseArrayWrapperDescriptor("[" + type) : ArrayNameMapper.getPreciseArrayWrapperDescriptor("[L" + type);
                this.mv.visitMethodInsn(184, wName, "initArray", "(I)L" + wName + ";", false);
                break;
            }
            case 192: {
                String wName = type;
                if (type.startsWith("[")) {
                    wName = ArrayNameMapper.getUnifyingArrayWrapperDescriptor(type);
                }
                this.mv.visitTypeInsn(opcode, wName);
                break;
            }
            case 193: {
                String wName = type;
                if (type.startsWith("[")) {
                    wName = ArrayNameMapper.getUnifyingArrayWrapperDescriptor(type);
                }
                this.mv.visitTypeInsn(opcode, wName);
                break;
            }
            default: {
                this.mv.visitTypeInsn(opcode, type);
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        String desc = descriptor;
        if (name.equals("avm_values") && SHADOW_JDK_ENUM_DESC.contains(descriptor)) {
            desc = "()[Ls/java/lang/Object;";
        } else if (name.equals("avm_clone") && !PRIMITIVE_ARRAY_FORMAT.matcher(owner).matches()) {
            opcode = 185;
            isInterface = true;
        }
        desc = ArrayNameMapper.updateMethodDesc(desc);
        String newOwner = ArrayNameMapper.getUnifyingArrayWrapperDescriptor(owner);
        this.mv.visitMethodInsn(opcode, newOwner, name, desc, isInterface);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        Object desc = descriptor;
        if (descriptor.startsWith("[")) {
            desc = "L" + ArrayNameMapper.getUnifyingArrayWrapperDescriptor(descriptor) + ";";
        }
        this.mv.visitLocalVariable(name, (String)desc, signature, start, end, index);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        Object desc = descriptor;
        if (descriptor.startsWith("[")) {
            desc = "L" + ArrayNameMapper.getUnifyingArrayWrapperDescriptor(descriptor) + ";";
        }
        this.mv.visitFieldInsn(opcode, owner, name, (String)desc);
    }

    public void visitMultiANewArrayInsn(String descriptor, int d) {
        String wName = ArrayNameMapper.getPreciseArrayWrapperDescriptor(descriptor);
        String facDesc = ArrayNameMapper.getFactoryDescriptor(wName, d);
        this.mv.visitMethodInsn(184, wName, "initArray", facDesc, false);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        String desc = ArrayNameMapper.updateMethodDesc(descriptor);
        super.visitInvokeDynamicInsn(name, desc, bootstrapMethodHandle, this.updateBootstrapMethodArguments(bootstrapMethodArguments));
    }

    private Object[] updateBootstrapMethodArguments(Object[] origArgs) {
        ArrayList<Type> newArgs = new ArrayList<Type>(origArgs.length);
        for (Object origArg : origArgs) {
            Object newArg = origArg instanceof Type ? this.updateTypeArgument((Type)origArg) : (origArg instanceof Handle ? this.updateHandleTypeArgument((Handle)origArg) : origArg);
            newArgs.add((Type)newArg);
        }
        return newArgs.toArray();
    }

    private Type updateTypeArgument(Type origType) {
        String newMethodDescriptor = ArrayNameMapper.updateMethodDesc(origType.getDescriptor());
        return Type.getMethodType((String)newMethodDescriptor);
    }

    private Handle updateHandleTypeArgument(Handle origHandle) {
        String newMethodDescriptor = ArrayNameMapper.updateMethodDesc(origHandle.getDesc());
        return new Handle(origHandle.getTag(), origHandle.getOwner(), origHandle.getName(), newMethodDescriptor, origHandle.isInterface());
    }
}

