/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.exceptionwrapping;

import i.RuntimeAssertionError;
import java.util.HashSet;
import java.util.Set;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.classgeneration.StubGenerator;
import org.aion.avm.core.exceptionwrapping.ExceptionWrapperNameMapper;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.CommonType;
import org.aion.avm.core.types.GeneratedClassConsumer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ExceptionWrapping
extends ClassToolchain.ToolChainClassVisitor {
    private final GeneratedClassConsumer generatedClassesSink;
    private final ClassHierarchy classHierarchy;
    private final Set<String> jclExceptionsSlashStyle;

    public ExceptionWrapping(GeneratedClassConsumer generatedClassesSink, ClassHierarchy classHierarchy) {
        super(458752);
        this.generatedClassesSink = generatedClassesSink;
        this.classHierarchy = classHierarchy;
        this.jclExceptionsSlashStyle = this.fetchAllJavaLangExceptionsSlashStyle();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String classDotName = name.replaceAll("/", ".");
        if (this.classHierarchy.isDescendantOfClass(classDotName, CommonType.SHADOW_THROWABLE.dotName)) {
            String reparentedName = ExceptionWrapperNameMapper.slashWrapperNameForClassName(name);
            String reparentedSuperName = ExceptionWrapperNameMapper.slashWrapperNameForClassName(superName);
            byte[] wrapperBytes = StubGenerator.generateWrapperClass(reparentedName, reparentedSuperName);
            this.generatedClassesSink.accept(reparentedSuperName, reparentedName, wrapperBytes);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodVisitor(458752, mv){
            private final Set<Label> catchTargets;
            private boolean isTargetFrame;
            {
                this.catchTargets = new HashSet<Label>();
                this.isTargetFrame = false;
            }

            public void visitLabel(Label label) {
                super.visitLabel(label);
                if (this.catchTargets.contains(label)) {
                    this.isTargetFrame = true;
                }
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                super.visitFrame(type, nLocal, local, nStack, stack);
                if (this.isTargetFrame) {
                    String castType = (String)stack[0];
                    String methodName = "unwrapThrowable";
                    String methodDescriptor = "(Ljava/lang/Throwable;)Ls/java/lang/Object;";
                    super.visitMethodInsn(184, "H", methodName, methodDescriptor, false);
                    boolean isPreRenameJavaException = ExceptionWrapping.this.jclExceptionsSlashStyle.contains(castType);
                    if (isPreRenameJavaException) {
                        RuntimeAssertionError.assertTrue(castType.equals("java/lang/Throwable"));
                    }
                    Object mappedCastType = isPreRenameJavaException ? "s/" + castType : castType;
                    super.visitTypeInsn(192, (String)mappedCastType);
                }
                this.isTargetFrame = false;
            }

            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                if (null != type) {
                    if (type.startsWith("s/")) {
                        String strippedClass = type.substring("s/".length());
                        super.visitTryCatchBlock(start, end, handler, strippedClass);
                        String wrapperType = ExceptionWrapperNameMapper.slashWrapperNameForClassName(type);
                        super.visitTryCatchBlock(start, end, handler, wrapperType);
                    } else {
                        String wrapperType = ExceptionWrapperNameMapper.slashWrapperNameForClassName(type);
                        super.visitTryCatchBlock(start, end, handler, wrapperType);
                    }
                } else {
                    super.visitTryCatchBlock(start, end, handler, type);
                }
                this.catchTargets.add(handler);
            }

            public void visitInsn(int opcode) {
                if (191 == opcode) {
                    String methodName = "wrapAsThrowable";
                    String methodDescriptor = "(Ls/java/lang/Object;)Ljava/lang/Throwable;";
                    super.visitMethodInsn(184, "H", methodName, methodDescriptor, false);
                }
                super.visitInsn(opcode);
            }
        };
    }

    private Set<String> fetchAllJavaLangExceptionsSlashStyle() {
        HashSet<String> javaLangExceptions = new HashSet<String>();
        for (CommonType type : CommonType.values()) {
            if (!type.isShadowException) continue;
            javaLangExceptions.add(type.dotName.substring("s.".length()).replaceAll("\\.", "/"));
        }
        return javaLangExceptions;
    }
}

