/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import java.util.HashMap;

public class BytecodeFeeScheduler {
    private HashMap<Integer, BytecodeFeeInfo> feeScheduleMap;

    public void initialize() {
        this.feeScheduleMap = new HashMap<Integer, BytecodeFeeInfo>(){
            {
                this.put(0, new BytecodeFeeInfo(BytecodeEnergyLevels.ZERO, BytecodeEnergyLevels.ZERO, 0, 0, 0));
                this.put(21, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(22, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(23, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(24, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(25, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(46, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(47, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(48, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(49, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(50, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(51, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(52, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(53, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(54, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(55, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(56, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(57, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(58, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(79, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(80, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(81, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(82, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(83, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(84, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(85, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(86, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(96, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(97, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(98, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(99, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(100, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(101, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(102, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(103, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(104, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(105, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(106, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(107, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(108, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(109, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(110, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(111, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(112, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(113, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(114, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(115, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(116, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(117, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(118, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(119, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(120, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(121, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(122, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(123, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(124, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(125, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(126, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(127, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(128, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(129, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(130, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(131, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(132, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 0, 0));
                this.put(148, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(149, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(150, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(151, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(152, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 1, 0));
                this.put(133, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(134, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(135, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(136, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(137, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(138, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(139, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(140, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(141, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(142, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(143, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(144, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(145, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(146, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(147, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(178, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(179, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 1, 0, 0));
                this.put(180, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 0, 1, 0));
                this.put(181, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.MACCESS, 2, 0, 0));
                this.put(187, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.CREATION, 0, 1, 0));
                this.put(188, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.CREATION, 1, 1, 0));
                this.put(189, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.CREATION, 1, 1, 0));
                this.put(190, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(192, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(193, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 1, 0));
                this.put(197, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.CREATION, 5, 1, 0));
                this.put(1, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(2, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(3, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(4, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(5, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(6, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(7, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(8, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(9, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(10, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(11, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(12, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(13, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(14, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(15, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(16, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(17, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(18, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(87, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(88, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.ZERO, 1, 0, 0));
                this.put(89, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 0, 1, 0));
                this.put(90, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 3, 0));
                this.put(91, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 3, 4, 0));
                this.put(92, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 4, 0));
                this.put(93, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 3, 5, 0));
                this.put(94, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 4, 6, 0));
                this.put(95, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.ZERO, 2, 2, 0));
                this.put(153, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(154, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(155, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(156, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(157, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(158, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(159, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(160, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(161, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(162, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(163, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(164, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(165, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(166, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 2, 0, 0));
                this.put(167, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 0, 0, 0));
                this.put(170, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(171, new BytecodeFeeInfo(BytecodeEnergyLevels.LOW, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(198, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(199, new BytecodeFeeInfo(BytecodeEnergyLevels.BASE, BytecodeEnergyLevels.FLOWCONTROL, 1, 0, 0));
                this.put(172, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(173, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(174, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(175, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(176, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(177, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 0, 0));
                this.put(182, new BytecodeFeeInfo(BytecodeEnergyLevels.HIGH, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(183, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(184, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(185, new BytecodeFeeInfo(BytecodeEnergyLevels.HIGH, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(186, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYHIGH, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
                this.put(191, new BytecodeFeeInfo(BytecodeEnergyLevels.VERYLOW, BytecodeEnergyLevels.FLOWCONTROL, 5, 1, 0));
            }
        };
        for (int op : this.feeScheduleMap.keySet()) {
            BytecodeFeeInfo feeInfo = this.feeScheduleMap.get(op);
            long fee = feeInfo.getNrgLvl().getVal() + feeInfo.getExtraNrgLvl().getVal();
            feeInfo.setFee(fee);
        }
    }

    public long getFee(int op) {
        if (this.feeScheduleMap.containsKey(op)) {
            return this.feeScheduleMap.get(op).getFee();
        }
        throw new IllegalArgumentException("This bytecode is not in the fee schedule.");
    }

    private class BytecodeFeeInfo {
        BytecodeEnergyLevels nrgLvl;
        BytecodeEnergyLevels extraNrgLvl;
        int delta;
        int alpha;
        long fee;

        private BytecodeFeeInfo(BytecodeEnergyLevels nrgLvl, BytecodeEnergyLevels extraNrgLvl, int delta, int alpha, int fee) {
            this.nrgLvl = nrgLvl;
            this.extraNrgLvl = extraNrgLvl;
            this.delta = delta;
            this.alpha = alpha;
            this.fee = fee;
        }

        public BytecodeEnergyLevels getNrgLvl() {
            return this.nrgLvl;
        }

        public BytecodeEnergyLevels getExtraNrgLvl() {
            return this.extraNrgLvl;
        }

        public int getDelta() {
            return this.delta;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public long getFee() {
            return this.fee;
        }

        private void setFee(long fee) {
            if (fee < 0L) {
                throw new IllegalArgumentException("Bytecode fee cannot be negative.");
            }
            this.fee = fee;
        }
    }

    public static enum BytecodeEnergyLevels {
        ZERO(0),
        BASE(2),
        VERYLOW(3),
        LOW(5),
        MID(8),
        HIGH(15),
        VERYHIGH(30),
        MACCESS(5),
        FLOWCONTROL(20),
        CREATION(40),
        MEMORY(3);

        private final int val;

        private BytecodeEnergyLevels(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }
}

