/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import i.RuntimeAssertionError;
import java.util.List;
import org.aion.avm.core.instrument.BasicBlock;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ChargeEnergyInjectionVisitor
extends MethodVisitor {
    private final List<BasicBlock> blocks;
    private boolean scanningToNewBlockStart;
    private int nextBlockIndexToWrite;

    public ChargeEnergyInjectionVisitor(MethodVisitor target, List<BasicBlock> blocks) {
        super(458752, target);
        this.blocks = blocks;
    }

    public void visitCode() {
        this.scanningToNewBlockStart = true;
        this.nextBlockIndexToWrite = 0;
        super.visitCode();
    }

    public void visitEnd() {
        RuntimeAssertionError.assertTrue(this.blocks.size() == this.nextBlockIndexToWrite);
        super.visitEnd();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.checkInject();
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    public void visitIincInsn(int var, int increment) {
        this.checkInject();
        super.visitIincInsn(var, increment);
    }

    public void visitInsn(int opcode) {
        this.checkInject();
        super.visitInsn(opcode);
        if (191 == opcode) {
            this.scanningToNewBlockStart = true;
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        this.checkInject();
        super.visitIntInsn(opcode, operand);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.checkInject();
        super.visitJumpInsn(opcode, label);
        this.scanningToNewBlockStart = true;
    }

    public void visitLabel(Label label) {
        this.scanningToNewBlockStart = true;
        super.visitLabel(label);
    }

    public void visitLdcInsn(Object value) {
        this.checkInject();
        super.visitLdcInsn(value);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkInject();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.checkInject();
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.checkInject();
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.checkInject();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.checkInject();
        super.visitTypeInsn(opcode, type);
    }

    public void visitVarInsn(int opcode, int var) {
        this.checkInject();
        super.visitVarInsn(opcode, var);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.checkInject();
        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    private void checkInject() {
        if (this.scanningToNewBlockStart) {
            BasicBlock currentBlock = this.blocks.get(this.nextBlockIndexToWrite);
            long currentEnergyCost = currentBlock.getEnergyCost();
            RuntimeAssertionError.assertTrue(currentEnergyCost > 0L);
            RuntimeAssertionError.assertTrue(currentEnergyCost <= Integer.MAX_VALUE);
            super.visitLdcInsn((Object)((int)currentEnergyCost));
            super.visitMethodInsn(184, "H", "chargeEnergy", "(I)V", false);
            this.scanningToNewBlockStart = false;
            ++this.nextBlockIndexToWrite;
        }
    }
}

