/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ClassRewriter {
    public static byte[] rewriteOneMethodInClass(byte[] classBytes, String methodName, IMethodReplacer replacer, int computeFrameFlag) {
        ClassWriter cw = new ClassWriter(computeFrameFlag);
        FullClassVisitor adapter = new FullClassVisitor((ClassVisitor)cw, methodName, replacer);
        ClassReader cr = new ClassReader(classBytes);
        cr.accept((ClassVisitor)adapter, 2);
        return cw.toByteArray();
    }

    public static interface IMethodReplacer {
        public void populatMethod(MethodVisitor var1);
    }

    private static class ReplacedMethodVisitor
    extends MethodVisitor
    implements Opcodes {
        private final MethodVisitor target;
        private final IMethodReplacer replacer;

        public ReplacedMethodVisitor(MethodVisitor target, IMethodReplacer replacer) {
            super(458752, null);
            this.target = target;
            this.replacer = replacer;
        }

        public void visitCode() {
            this.replacer.populatMethod(this.target);
        }
    }

    private static class FullClassVisitor
    extends ClassVisitor
    implements Opcodes {
        private final String methodName;
        private final IMethodReplacer replacer;

        public FullClassVisitor(ClassVisitor cv, String methodName, IMethodReplacer replacer) {
            super(458752, cv);
            this.methodName = methodName;
            this.replacer = replacer;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor resultantVisitor = null;
            if (this.methodName.equals(name)) {
                MethodVisitor originalVisitor = super.visitMethod(access & 0xFFFFFEFF, name, descriptor, null, exceptions);
                ReplacedMethodVisitor replacedVisitor = new ReplacedMethodVisitor(originalVisitor, this.replacer);
                if (0 != (access & 0x100)) {
                    replacedVisitor.visitCode();
                }
                resultantVisitor = replacedVisitor;
            } else {
                resultantVisitor = super.visitMethod(access, name, descriptor, null, exceptions);
            }
            return resultantVisitor;
        }
    }
}

