/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.util.DescriptorParser;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassRenameVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private final String targetSlashName;
    private String originalSlashName;

    public ClassRenameVisitor(String targetSlashName) {
        super(458752);
        this.targetSlashName = targetSlashName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.originalSlashName = name;
        super.visit(version, access, this.targetSlashName, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return super.visitField(access, name, this.mapDescriptor(descriptor), null, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, this.mapDescriptor(descriptor), null, exceptions);
        return new MethodVisitor(458752, visitor){

            public void visitTypeInsn(int opcode, String type) {
                super.visitTypeInsn(opcode, ClassRenameVisitor.this.mapName(type));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                super.visitFieldInsn(opcode, ClassRenameVisitor.this.mapName(owner), name, ClassRenameVisitor.this.mapDescriptor(descriptor));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                super.visitMethodInsn(opcode, ClassRenameVisitor.this.mapName(owner), name, ClassRenameVisitor.this.mapDescriptor(descriptor), isInterface);
            }
        };
    }

    private String mapDescriptor(String descriptor) {
        StringBuilder builder = DescriptorParser.parse(descriptor, new DescriptorParser.Callbacks<StringBuilder>(){

            @Override
            public StringBuilder readObject(int arrayDimensions, String type, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('L');
                String typeName = ClassRenameVisitor.this.mapName(type);
                userData.append(typeName);
                userData.append(';');
                return userData;
            }

            @Override
            public StringBuilder readBoolean(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('Z');
                return userData;
            }

            @Override
            public StringBuilder readShort(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('S');
                return userData;
            }

            @Override
            public StringBuilder readLong(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('J');
                return userData;
            }

            @Override
            public StringBuilder readInteger(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('I');
                return userData;
            }

            @Override
            public StringBuilder readFloat(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('F');
                return userData;
            }

            @Override
            public StringBuilder readDouble(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('D');
                return userData;
            }

            @Override
            public StringBuilder readChar(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('C');
                return userData;
            }

            @Override
            public StringBuilder readByte(int arrayDimensions, StringBuilder userData) {
                this.writeArray(arrayDimensions, userData);
                userData.append('B');
                return userData;
            }

            @Override
            public StringBuilder argumentStart(StringBuilder userData) {
                userData.append('(');
                return userData;
            }

            @Override
            public StringBuilder argumentEnd(StringBuilder userData) {
                userData.append(')');
                return userData;
            }

            @Override
            public StringBuilder readVoid(StringBuilder userData) {
                userData.append('V');
                return userData;
            }

            private void writeArray(int arrayDimensions, StringBuilder userData) {
                for (int i = 0; i < arrayDimensions; ++i) {
                    userData.append('[');
                }
            }
        }, new StringBuilder());
        return builder.toString();
    }

    private String mapName(String name) {
        return this.originalSlashName.equals(name) ? this.targetSlashName : name;
    }
}

