/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.types.GeneratedClassConsumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class InterfaceFieldClassGeneratorVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private GeneratedClassConsumer consumer;
    private Map<String, String> interfaceFieldClassNames;
    private String javaLangObject;
    private boolean isInterface = false;
    private String className = null;
    private int access = 0;
    private List<FieldNode> fields = new ArrayList<FieldNode>();
    private MethodNode clinit = null;
    private List<String> innerClassNames;
    private String generatedClassName;
    private String prefix;

    public InterfaceFieldClassGeneratorVisitor(GeneratedClassConsumer consumer, Map<String, String> interfaceFieldClassNames, String javaLangObjectSlashName) {
        super(458752);
        this.consumer = consumer;
        this.interfaceFieldClassNames = interfaceFieldClassNames;
        this.javaLangObject = javaLangObjectSlashName;
        this.innerClassNames = new ArrayList<String>();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x200) != 0) {
            this.isInterface = true;
            this.className = name;
            this.access = access;
            this.prefix = this.className + "$FIELDS";
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv;
        if (this.isInterface && "<clinit>".equals(name)) {
            this.clinit = new MethodNode(access, name, descriptor, signature, exceptions);
            mv = new MethodVisitor(458752, (MethodVisitor)this.clinit){

                public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                    if (InterfaceFieldClassGeneratorVisitor.this.className.equals(owner)) {
                        if (InterfaceFieldClassGeneratorVisitor.this.generatedClassName == null) {
                            InterfaceFieldClassGeneratorVisitor.this.generatedClassName = InterfaceFieldClassGeneratorVisitor.this.getNextAvailableFieldsClassName();
                        }
                        owner = InterfaceFieldClassGeneratorVisitor.this.generatedClassName;
                    }
                    super.visitFieldInsn(opcode, owner, name, descriptor);
                }
            };
        } else {
            mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        return mv;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        FieldVisitor fv;
        if (this.isInterface) {
            FieldNode field = new FieldNode(access, name, descriptor, signature, value);
            this.fields.add(field);
            fv = null;
        } else {
            fv = super.visitField(access, name, descriptor, signature, value);
        }
        return fv;
    }

    public void visitInnerClass(String name, String outer, String innerName, int access) {
        if (this.isInterface && name.startsWith(this.prefix)) {
            this.innerClassNames.add(name);
        }
        super.visitInnerClass(name, outer, innerName, access);
    }

    public void visitEnd() {
        if (this.isInterface && this.fields.size() > 0) {
            if (this.generatedClassName == null) {
                this.generatedClassName = this.getNextAvailableFieldsClassName();
            }
            this.interfaceFieldClassNames.put(this.className, this.generatedClassName);
            String genSuperName = this.javaLangObject;
            int genAccess = this.access & 0xFFFFFDFF;
            ClassWriter cw = new ClassWriter(0);
            cw.visit(50, genAccess, this.generatedClassName, null, genSuperName, null);
            MethodVisitor mv = cw.visitMethod(2, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.javaLangObject, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            for (FieldNode field : this.fields) {
                field.accept((ClassVisitor)cw);
            }
            if (this.clinit != null) {
                this.clinit.accept((ClassVisitor)cw);
            }
            this.consumer.accept(genSuperName, this.generatedClassName, cw.toByteArray());
        }
    }

    private String getNextAvailableFieldsClassName() {
        int suffix = 0;
        if (!this.innerClassNames.contains(this.prefix)) {
            return this.prefix;
        }
        while (this.innerClassNames.contains(this.prefix + suffix)) {
            ++suffix;
        }
        return this.prefix + suffix;
    }
}

