/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.RuntimeAssertionError;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class ConstructorThisInterpreter
extends Interpreter<ThisValue> {
    private final BasicInterpreter underlying = new BasicInterpreter();
    private boolean isNextThis = true;

    public ConstructorThisInterpreter() {
        super(458752);
    }

    public ThisValue newValue(Type type) {
        ThisValue result = null;
        BasicValue original = this.underlying.newValue(type);
        if (null != original) {
            if (this.isNextThis) {
                result = ThisValue.createThis(original);
                this.isNextThis = false;
            } else {
                result = ThisValue.createNotThis(original);
            }
        }
        return result;
    }

    public ThisValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        BasicValue basic = this.underlying.newOperation(insn);
        return ThisValue.createNotThis(basic);
    }

    public ThisValue copyOperation(AbstractInsnNode insn, ThisValue value) throws AnalyzerException {
        boolean isThis = value.isThis;
        BasicValue basic = this.underlying.copyOperation(insn, value.underlying);
        return isThis ? ThisValue.createThis(basic) : ThisValue.createNotThis(basic);
    }

    public ThisValue unaryOperation(AbstractInsnNode insn, ThisValue value) throws AnalyzerException {
        BasicValue basic = this.underlying.unaryOperation(insn, value.underlying);
        return null != basic ? ThisValue.createNotThis(basic) : null;
    }

    public ThisValue binaryOperation(AbstractInsnNode insn, ThisValue value1, ThisValue value2) throws AnalyzerException {
        BasicValue basic = this.underlying.binaryOperation(insn, value1.underlying, value2.underlying);
        return null != basic ? ThisValue.createNotThis(basic) : null;
    }

    public ThisValue ternaryOperation(AbstractInsnNode insn, ThisValue value1, ThisValue value2, ThisValue value3) throws AnalyzerException {
        BasicValue basic = this.underlying.ternaryOperation(insn, value1.underlying, value2.underlying, value3.underlying);
        return null != basic ? ThisValue.createNotThis(basic) : null;
    }

    public ThisValue naryOperation(AbstractInsnNode insn, List<? extends ThisValue> values) throws AnalyzerException {
        List basics = values.stream().map(value -> value.underlying).collect(Collectors.toList());
        BasicValue basic = this.underlying.naryOperation(insn, basics);
        return null != basic ? ThisValue.createNotThis(basic) : null;
    }

    public void returnOperation(AbstractInsnNode insn, ThisValue value, ThisValue expected) throws AnalyzerException {
        this.underlying.returnOperation(insn, value.underlying, expected.underlying);
    }

    public ThisValue merge(ThisValue value1, ThisValue value2) {
        boolean isThis = value1.isThis && value2.isThis;
        BasicValue basic = this.underlying.merge(value1.underlying, value2.underlying);
        return isThis ? ThisValue.createThis(basic) : ThisValue.createNotThis(basic);
    }

    public static class ThisValue
    implements Value {
        public final boolean isThis;
        public final BasicValue underlying;

        public static ThisValue createThis(BasicValue underlying) {
            return new ThisValue(true, underlying);
        }

        public static ThisValue createNotThis(BasicValue underlying) {
            return new ThisValue(false, underlying);
        }

        private ThisValue(boolean isThis, BasicValue underlying) {
            RuntimeAssertionError.assertTrue(null != underlying);
            this.isThis = isThis;
            this.underlying = underlying;
        }

        public int getSize() {
            return this.underlying.getSize();
        }

        public int hashCode() {
            return this.underlying.hashCode();
        }

        public boolean equals(Object obj) {
            boolean isEqual;
            boolean bl = isEqual = this == obj;
            if (!isEqual && obj instanceof ThisValue) {
                ThisValue other = (ThisValue)obj;
                isEqual = this.isThis == other.isThis && this.underlying.equals((Object)other.underlying);
            }
            return isEqual;
        }
    }
}

