/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.RuntimeAssertionError;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.aion.avm.core.persistence.ByteBufferObjectDeserializer;
import org.aion.avm.core.persistence.IGlobalResolver;
import org.aion.avm.core.persistence.IPersistenceNameMapper;
import org.aion.avm.core.persistence.SortedFieldCache;

public class Deserializer {
    public static int deserializeEntireGraphAndNextHashCode(ByteBuffer inputBuffer, List<Object> existingObjectIndex, IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, Class<?>[] sortedRoots, Class<?> constantClass) {
        int nextHashCode = inputBuffer.getInt();
        inputBuffer = inputBuffer.slice();
        Deserializer.deserializeEntireGraph(inputBuffer, existingObjectIndex, resolver, cache, classNameMapper, sortedRoots, constantClass, null);
        return nextHashCode;
    }

    public static void deserializeEntireGraph(ByteBuffer inputBuffer, List<Object> existingObjectIndex, IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, Class<?>[] sortedRoots, Class<?> constantClass, Object[] mainInstanceBuf) {
        RuntimeAssertionError.assertTrue(ByteOrder.BIG_ENDIAN == inputBuffer.order());
        ByteBufferObjectDeserializer prePassDeserializer = new ByteBufferObjectDeserializer(inputBuffer, null, cache, resolver, classNameMapper);
        if (mainInstanceBuf != null) {
            mainInstanceBuf[0] = prePassDeserializer.readObject();
        }
        Deserializer.deserializeClassStatics(prePassDeserializer, cache, sortedRoots, constantClass);
        List<Object> instanceList = Deserializer.createAllInstancesFromBuffer(prePassDeserializer, existingObjectIndex, cache, classNameMapper);
        inputBuffer.rewind();
        ByteBufferObjectDeserializer objectDeserializer = new ByteBufferObjectDeserializer(inputBuffer, instanceList, cache, resolver, classNameMapper);
        if (mainInstanceBuf != null) {
            mainInstanceBuf[0] = objectDeserializer.readObject();
        }
        Deserializer.deserializeClassStatics(objectDeserializer, cache, sortedRoots, constantClass);
        Deserializer.populateAllInstancesFromBuffer(objectDeserializer, instanceList, cache);
    }

    public static Object deserializeObject(ByteBuffer inputBuffer, IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper) {
        RuntimeAssertionError.assertTrue(ByteOrder.BIG_ENDIAN == inputBuffer.order());
        ByteBufferObjectDeserializer prePassDeserializer = new ByteBufferObjectDeserializer(inputBuffer, null, cache, resolver, classNameMapper);
        Object val = prePassDeserializer.readObject();
        List<Object> instanceList = Deserializer.createAllInstancesFromBuffer(prePassDeserializer, null, cache, classNameMapper, true);
        inputBuffer.rewind();
        ByteBufferObjectDeserializer objectDeserializer = new ByteBufferObjectDeserializer(inputBuffer, instanceList, cache, resolver, classNameMapper);
        val = objectDeserializer.readObject();
        Deserializer.populateAllInstancesFromBuffer(objectDeserializer, instanceList, cache);
        return val;
    }

    public static void cleanClassStatics(SortedFieldCache cache, Class<?>[] sortedRoots, Class<?> constantClass) {
        Deserializer.cleanOneClass(cache, constantClass);
        for (Class<?> clazz : sortedRoots) {
            Deserializer.cleanOneClass(cache, clazz);
        }
    }

    private static void cleanOneClass(SortedFieldCache cache, Class<?> clazz) {
        Field[] constants = cache.getConstantFields(clazz);
        Deserializer.cleanFieldsForClass(constants);
        Field[] fields = cache.getUserStaticFields(clazz);
        Deserializer.cleanFieldsForClass(fields);
    }

    private static void cleanFieldsForClass(Field[] fields) {
        try {
            for (Field field : fields) {
                Class<?> type = field.getType();
                if (Boolean.TYPE == type || Byte.TYPE == type || Short.TYPE == type || Character.TYPE == type || Integer.TYPE == type || Float.TYPE == type || Long.TYPE == type || Double.TYPE == type) continue;
                field.set(null, null);
            }
        }
        catch (IllegalAccessException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }

    private static void deserializeClassStatics(ByteBufferObjectDeserializer objectDeserializer, SortedFieldCache cache, Class<?>[] sortedRoots, Class<?> constantClass) {
        Deserializer.deserializeConstantClass(objectDeserializer, cache, constantClass);
        for (Class<?> clazz : sortedRoots) {
            Deserializer.deserializeOneUserClass(objectDeserializer, cache, clazz);
        }
    }

    private static void deserializeConstantClass(ByteBufferObjectDeserializer objectDeserializer, SortedFieldCache cache, Class<?> constantClass) {
        Field[] constants = cache.getConstantFields(constantClass);
        Deserializer.deserializeFieldsForClass(objectDeserializer, constants);
    }

    private static void deserializeOneUserClass(ByteBufferObjectDeserializer objectDeserializer, SortedFieldCache cache, Class<?> clazz) {
        Field[] fields = cache.getUserStaticFields(clazz);
        Deserializer.deserializeFieldsForClass(objectDeserializer, fields);
    }

    private static List<Object> createAllInstancesFromBuffer(ByteBufferObjectDeserializer objectDeserializer, List<Object> existingObjectIndex, SortedFieldCache cache, IPersistenceNameMapper classNameMapper) {
        return Deserializer.createAllInstancesFromBuffer(objectDeserializer, existingObjectIndex, cache, classNameMapper, false);
    }

    private static List<Object> createAllInstancesFromBuffer(ByteBufferObjectDeserializer objectDeserializer, List<Object> existingObjectIndex, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, boolean singleObject) {
        Method deserializeSelfMethod = cache.getDeserializeSelfMethod();
        ArrayList<Object> instanceList = new ArrayList<Object>();
        int readIndex = 0;
        boolean isDeserializingIntoCallerObjects = null != existingObjectIndex;
        try {
            boolean keepRunning = true;
            while (keepRunning) {
                String internalClassName = null;
                try {
                    internalClassName = objectDeserializer.readClassName();
                }
                catch (BufferUnderflowException done) {
                    keepRunning = false;
                }
                if (!keepRunning) continue;
                Object instance = isDeserializingIntoCallerObjects && null != existingObjectIndex.get(readIndex) ? existingObjectIndex.get(readIndex) : cache.getNewInstance(internalClassName, isDeserializingIntoCallerObjects || singleObject ? -1 : readIndex);
                deserializeSelfMethod.invoke(instance, null, objectDeserializer);
                instanceList.add(instance);
                ++readIndex;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        return instanceList;
    }

    private static void populateAllInstancesFromBuffer(ByteBufferObjectDeserializer objectDeserializer, List<Object> instanceList, SortedFieldCache cache) {
        Method deserializeSelfMethod = cache.getDeserializeSelfMethod();
        try {
            for (Object instance : instanceList) {
                objectDeserializer.readClassName();
                deserializeSelfMethod.invoke(instance, null, objectDeserializer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }

    private static void deserializeFieldsForClass(ByteBufferObjectDeserializer objectDeserializer, Field[] fields) {
        try {
            for (Field field : fields) {
                Class<?> type = field.getType();
                if (Boolean.TYPE == type) {
                    boolean val = objectDeserializer.readBoolean();
                    field.setBoolean(null, val);
                    continue;
                }
                if (Byte.TYPE == type) {
                    byte val = objectDeserializer.readByte();
                    field.setByte(null, val);
                    continue;
                }
                if (Short.TYPE == type) {
                    short val = objectDeserializer.readShort();
                    field.setShort(null, val);
                    continue;
                }
                if (Character.TYPE == type) {
                    char val = objectDeserializer.readChar();
                    field.setChar(null, val);
                    continue;
                }
                if (Integer.TYPE == type) {
                    int val = objectDeserializer.readInt();
                    field.setInt(null, val);
                    continue;
                }
                if (Float.TYPE == type) {
                    float val = objectDeserializer.readFloat();
                    field.setFloat(null, val);
                    continue;
                }
                if (Long.TYPE == type) {
                    long val = objectDeserializer.readLong();
                    field.setLong(null, val);
                    continue;
                }
                if (Double.TYPE == type) {
                    double val = objectDeserializer.readDouble();
                    field.setDouble(null, val);
                    continue;
                }
                Object val = objectDeserializer.readObject();
                field.set(null, val);
            }
        }
        catch (IllegalAccessException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }
}

