/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.RuntimeAssertionError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SortedFieldCache {
    private static final String CONSTANT_FIELD_PREFIX = "const_";
    private final Map<String, Class<?>> internalNameClasses = new HashMap();
    private final Map<Class<?>, Field[]> constantFields = new HashMap();
    private final Map<Class<?>, Field[]> staticFields = new HashMap();
    private final Map<Class<?>, Field[]> instanceFields = new HashMap();
    private final ClassLoader dappClassLoader;
    private final Method serializeSelf;
    private final Method deserializeSelf;
    private final Field readIndex;

    public SortedFieldCache(ClassLoader dappClassLoader, Method serializeSelf, Method deserializeSelf, Field readIndex) {
        this.dappClassLoader = dappClassLoader;
        this.serializeSelf = serializeSelf;
        this.deserializeSelf = deserializeSelf;
        this.readIndex = readIndex;
    }

    public Field[] getConstantFields(Class<?> clazz) {
        Field[] result = this.constantFields.get(clazz);
        if (null == result) {
            Field[] allFields = clazz.getDeclaredFields();
            result = (Field[])Arrays.stream(allFields).filter(field -> 8 == (8 & field.getModifiers())).filter(field -> field.getName().startsWith(CONSTANT_FIELD_PREFIX)).sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).map(field -> {
                field.setAccessible(true);
                return field;
            }).toArray(Field[]::new);
            this.constantFields.put(clazz, result);
        }
        return result;
    }

    public Field[] getUserStaticFields(Class<?> clazz) {
        Field[] result = this.staticFields.get(clazz);
        if (null == result) {
            Field[] allFields = clazz.getDeclaredFields();
            result = (Field[])Arrays.stream(allFields).filter(field -> 8 == (8 & field.getModifiers())).filter(field -> !field.getName().startsWith(CONSTANT_FIELD_PREFIX)).sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).map(field -> {
                field.setAccessible(true);
                return field;
            }).toArray(Field[]::new);
            this.staticFields.put(clazz, result);
        }
        return result;
    }

    public Field[] getInstanceFields(Class<?> clazz) {
        Field[] result = this.instanceFields.get(clazz);
        if (null == result) {
            Field[] allFields = clazz.getDeclaredFields();
            result = (Field[])Arrays.stream(allFields).filter(field -> 8 != (8 & field.getModifiers())).sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).map(field -> {
                field.setAccessible(true);
                return field;
            }).toArray(Field[]::new);
            this.instanceFields.put(clazz, result);
        }
        return result;
    }

    public Method getSerializeSelfMethod() {
        return this.serializeSelf;
    }

    public Method getDeserializeSelfMethod() {
        return this.deserializeSelf;
    }

    public Field getReadIndexField() {
        return this.readIndex;
    }

    public Object getNewInstance(String internalClassName, int readIndex) {
        Class<?> clazz = this.internalNameClasses.get(internalClassName);
        if (null == clazz) {
            try {
                clazz = this.dappClassLoader.loadClass(internalClassName);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeAssertionError.unexpected(e);
            }
            this.internalNameClasses.put(internalClassName, clazz);
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(Void.class, Integer.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(null, readIndex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }
}

